/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.fse.serializer.extra;

import com.jfirer.fse.CycleFlagSerializer;
import com.jfirer.fse.FseContext;
import com.jfirer.fse.FseSerializer;
import com.jfirer.fse.InternalByteArray;
import com.jfirer.fse.SerializerFactory;
import java.util.HashSet;

public class HashSetSerializer
extends CycleFlagSerializer
implements FseSerializer {
    @Override
    public void init(Class<?> type, SerializerFactory serializerFactory) {
    }

    @Override
    public void doWriteToBytes(Object o, InternalByteArray byteArray, FseContext fseContext, int depth) {
        HashSet set = (HashSet)o;
        byteArray.writePositive(set.size());
        for (Object each : set) {
            if (each == null) {
                byteArray.writeVarInt(0);
                continue;
            }
            fseContext.serialize(each, byteArray, depth);
        }
    }

    @Override
    public Object readBytes(InternalByteArray byteArray, FseContext fseContext) {
        int size = byteArray.readPositive();
        HashSet<Object> set = new HashSet<Object>();
        fseContext.collectObject(set);
        for (int i = 0; i < size; ++i) {
            int result = byteArray.readVarInt();
            if (result == 0) {
                set.add(null);
                continue;
            }
            if (result > 0) {
                Object element = fseContext.getClassRegistry(result).getSerializer().readBytes(byteArray, fseContext);
                set.add(element);
                continue;
            }
            set.add(fseContext.getObjectByIndex(0 - result));
        }
        return set;
    }
}

