/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.fse.serializer.extra;

import com.jfirer.baseutil.reflect.ReflectUtil;
import com.jfirer.fse.CycleFlagSerializer;
import com.jfirer.fse.FseContext;
import com.jfirer.fse.FseSerializer;
import com.jfirer.fse.InternalByteArray;
import com.jfirer.fse.SerializerFactory;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class MethodSerializer
extends CycleFlagSerializer
implements FseSerializer {
    private Map<String, Class> nameToClass = new HashMap<String, Class>();

    @Override
    public void init(Class<?> type, SerializerFactory serializerFactory) {
    }

    @Override
    public void writeToBytes(Object o, int classIndex, InternalByteArray byteArray, FseContext fseContext, int depth) {
        byteArray.writeVarInt(classIndex);
        Method method = (Method)o;
        Class<?> declaringClass = method.getDeclaringClass();
        byteArray.writeString(declaringClass.getName());
        byteArray.writeString(method.getName());
        Class<?>[] parameterTypes = method.getParameterTypes();
        byteArray.writePositive(parameterTypes.length);
        for (Class<?> each : parameterTypes) {
            int id = fseContext.getClassRegistry(each).getId();
            byteArray.writePositive(id);
        }
    }

    @Override
    public Object readBytes(InternalByteArray byteArray, FseContext fseContext) {
        String className = byteArray.readString();
        Class<?> ckass = this.nameToClass.get(className);
        if (ckass == null) {
            try {
                ckass = Class.forName(className);
                this.nameToClass.put(className, ckass);
            }
            catch (ClassNotFoundException e) {
                ReflectUtil.throwException((Throwable)e);
            }
        }
        String methodName = byteArray.readString();
        int numOfParameterType = byteArray.readPositive();
        try {
            if (numOfParameterType == 0) {
                return ckass.getDeclaredMethod(methodName, new Class[0]);
            }
            Class[] parameterTypes = new Class[numOfParameterType];
            for (int i = 0; i < parameterTypes.length; ++i) {
                parameterTypes[i] = fseContext.getClassRegistry(byteArray.readPositive()).getCkass();
            }
            return ckass.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            ReflectUtil.throwException((Throwable)e);
            return null;
        }
    }
}

