/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.jfireel.expression.node.impl;

import com.jfirer.baseutil.StringUtil;
import com.jfirer.baseutil.reflect.ReflectUtil;
import com.jfirer.baseutil.reflect.ValueAccessor;
import com.jfirer.jfireel.expression.node.CalculateNode;
import com.jfirer.jfireel.expression.token.Token;
import com.jfirer.jfireel.expression.token.TokenType;
import java.lang.reflect.Field;
import java.util.Map;

public class ObjectPropertyNode
implements CalculateNode {
    protected Class<?> beanType;
    protected String propertyName;
    protected boolean recognizeEveryTime = true;
    private CalculateNode beanNode;
    private volatile ValueAccessor valueAccessor;

    public ObjectPropertyNode(String literals, CalculateNode beanNode, boolean recognizeEveryTime) {
        this.propertyName = literals;
        this.beanNode = beanNode;
        this.recognizeEveryTime = recognizeEveryTime;
    }

    @Override
    public Object calculate(Map<String, Object> variables) {
        Object value = this.beanNode.calculate(variables);
        if (value == null) {
            return null;
        }
        try {
            return this.getValueAccessor(value).get(value);
        }
        catch (Exception e) {
            ReflectUtil.throwException((Throwable)e);
            return null;
        }
    }

    @Override
    public TokenType type() {
        return Token.PROPERTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ValueAccessor getValueAccessor(Object value) {
        ValueAccessor valueAccessor = this.valueAccessor;
        if (this.recognizeEveryTime) {
            if (valueAccessor == null || this.beanType.isAssignableFrom(value.getClass())) {
                ObjectPropertyNode objectPropertyNode = this;
                synchronized (objectPropertyNode) {
                    valueAccessor = this.valueAccessor;
                    if (valueAccessor == null || this.beanType.isAssignableFrom(value.getClass())) {
                        return this.buildValueAccessor(value);
                    }
                }
            }
            return valueAccessor;
        }
        if (valueAccessor == null) {
            ObjectPropertyNode objectPropertyNode = this;
            synchronized (objectPropertyNode) {
                valueAccessor = this.valueAccessor;
                if (valueAccessor == null) {
                    return this.buildValueAccessor(value);
                }
            }
        }
        return valueAccessor;
    }

    private ValueAccessor buildValueAccessor(Object value) {
        Class<?> ckass = value.getClass();
        while (ckass != Object.class) {
            try {
                Field propertyField = ckass.getDeclaredField(this.propertyName);
                this.beanType = value.getClass();
                ValueAccessor valueAccessor = this.valueAccessor = new ValueAccessor(propertyField);
                return valueAccessor;
            }
            catch (NoSuchFieldException e) {
                ckass = ckass.getSuperclass();
            }
            catch (SecurityException e) {
                ReflectUtil.throwException((Throwable)e);
            }
        }
        throw new NullPointerException(StringUtil.format((String)"\u65e0\u6cd5\u5728\u7c7b{}\u4e2d\u627e\u5230\u5c5e\u6027:{}", (Object[])new Object[]{value.getClass(), this.propertyName}));
    }

    @Override
    public String literals() {
        return this.beanNode.literals() + "." + this.propertyName;
    }

    public String toString() {
        return this.literals();
    }
}

