/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.jfireel.expression.node.impl;

import com.jfirer.baseutil.reflect.ReflectUtil;
import com.jfirer.jfireel.expression.node.CalculateNode;
import com.jfirer.jfireel.expression.node.MethodNode;
import com.jfirer.jfireel.expression.token.Token;
import com.jfirer.jfireel.expression.token.TokenType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;

public class StaticObjectMethodNode
implements MethodNode {
    private final Class<?> beanType;
    private volatile Method method;
    private String methodName;
    private CalculateNode[] argsNodes;
    private MethodNode.ConvertType[] convertTypes;
    private Token type;

    public StaticObjectMethodNode(String literals, CalculateNode beanNode) {
        if (beanNode.type() != Token.TYPE) {
            throw new IllegalArgumentException("\u9759\u6001\u65b9\u6cd5\u7684\u524d\u9762\u4e00\u4e2a\u8282\u70b9\u5fc5\u987b\u662f\u7c7b\u578b\u8282\u70b9");
        }
        this.beanType = (Class)beanNode.calculate(null);
        this.methodName = literals;
        this.type = Token.METHOD;
    }

    @Override
    public Object calculate(Map<String, Object> variables) {
        Object[] args = new Object[this.argsNodes.length];
        try {
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.argsNodes[i].calculate(variables);
            }
            Method invoke = this.getMethod(args);
            MethodNode.MethodNodeUtil.convertArgs(args, this.convertTypes);
            return invoke.invoke(null, args);
        }
        catch (Exception e) {
            ReflectUtil.throwException((Throwable)e);
            return null;
        }
    }

    @Override
    public TokenType type() {
        return this.type;
    }

    private Method getMethod(Object[] args) {
        if (this.method == null) {
            StaticObjectMethodNode staticObjectMethodNode = this;
            synchronized (staticObjectMethodNode) {
                if (this.method == null) {
                    block3: for (Method each : this.beanType.getMethods()) {
                        if (!Modifier.isStatic(each.getModifiers()) || !each.getName().equals(this.methodName) || each.getParameterTypes().length != args.length) continue;
                        Class<?>[] parameterTypes = each.getParameterTypes();
                        for (int i = 0; i < args.length; ++i) {
                            if (parameterTypes[i].isPrimitive() ? args[i] == null || !MethodNode.MethodNodeUtil.isWrapType(parameterTypes[i], args[i].getClass()) : args[i] != null && !parameterTypes[i].isAssignableFrom(args[i].getClass())) continue block3;
                        }
                        this.convertTypes = MethodNode.MethodNodeUtil.buildConvertTypes(parameterTypes);
                        each.setAccessible(true);
                        this.method = each;
                        return this.method;
                    }
                }
                throw new NullPointerException("\u6ca1\u6709\u5728\u7c7b" + this.beanType.getName() + "\u627e\u5230\u9759\u6001\u65b9\u6cd5" + this.methodName);
            }
        }
        return this.method;
    }

    @Override
    public void setArgsNodes(CalculateNode[] argsNodes) {
        this.argsNodes = argsNodes;
        this.type = Token.METHOD_RESULT;
    }

    @Override
    public String literals() {
        StringBuilder cache = new StringBuilder();
        cache.append(this.beanType.getName()).append('.').append(this.methodName).append('(');
        if (this.argsNodes != null) {
            for (CalculateNode each : this.argsNodes) {
                cache.append(each.literals()).append(',');
            }
            if (cache.charAt(cache.length() - 1) == ',') {
                cache.setLength(cache.length() - 1);
            }
        }
        cache.append(')');
        return cache.toString();
    }

    public String toString() {
        return this.literals();
    }
}

