/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.jfireel.expression.parse.impl;

import com.jfirer.jfireel.expression.node.CalculateNode;
import com.jfirer.jfireel.expression.node.impl.NumberNode;
import com.jfirer.jfireel.expression.parse.Invoker;
import com.jfirer.jfireel.expression.parse.impl.NodeParser;
import com.jfirer.jfireel.expression.token.Operator;
import com.jfirer.jfireel.expression.util.CharType;
import java.util.Deque;

public class NumberParser
extends NodeParser {
    private boolean match(String el, int offset, Deque<CalculateNode> nodes, int function) {
        if ('-' == this.getChar(offset, el)) {
            if (nodes.peek() != null && !(nodes.peek().type() instanceof Operator)) {
                return false;
            }
            if (CharType.isDigital(this.getChar(offset + 1, el))) {
                return true;
            }
            throw new IllegalArgumentException("\u65e0\u6cd5\u8bc6\u522b\u7684-\u7b26\u53f7\uff0c\u4e0d\u662f\u8d1f\u6570\u4e5f\u4e0d\u662f\u64cd\u4f5c\u7b26,\u95ee\u9898\u533a\u95f4:" + el.substring(0, offset));
        }
        return CharType.isDigital(this.getChar(offset, el));
    }

    @Override
    public int parse(String el, int offset, Deque<CalculateNode> nodes, int function, Invoker next) {
        if (!this.match(el, offset, nodes, function)) {
            return next.parse(el, offset, nodes, function);
        }
        int index = offset;
        char c = this.getChar(offset, el);
        if (c == '-') {
            ++offset;
        }
        boolean hasDot = false;
        while (CharType.isDigital(c = this.getChar(offset, el)) || !hasDot && c == '.') {
            ++offset;
            if (c != '.') continue;
            hasDot = true;
        }
        if (c == '.') {
            throw new IllegalArgumentException("\u975e\u6cd5\u7684\u8d1f\u6570\u683c\u5f0f,\u95ee\u9898\u533a\u95f4:" + el.substring(index, offset));
        }
        String literals = el.substring(index, offset);
        nodes.push(new NumberNode(literals));
        return offset;
    }
}

