/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.jfireel.expression.token;

import com.jfirer.jfireel.expression.token.TokenType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum Operator implements TokenType
{
    PLUS("+"),
    MINUS("-"),
    MULTI("*"),
    DIVISION("/"),
    QUESTION("?"),
    EQ("=="),
    GT(">"),
    LT("<"),
    PERCENT("%"),
    COLON(":"),
    LT_EQ("<="),
    GT_EQ(">="),
    NOT_EQ("!="),
    DOUBLE_AMP("&&"),
    DOUBLE_BAR("||");

    private static Map<String, Operator> symbols;
    private static Set<Operator> store;
    private final String literals;

    private Operator(String literals) {
        this.literals = literals;
    }

    public static Operator literalsOf(String literals) {
        return symbols.get(literals);
    }

    public static boolean isOperator(TokenType type) {
        return store.contains(type);
    }

    public String getLiterals() {
        return this.literals;
    }

    static {
        symbols = new HashMap<String, Operator>(128);
        store = new HashSet<Operator>();
        for (Operator each : Operator.values()) {
            symbols.put(each.getLiterals(), each);
            store.add(each);
        }
    }
}

