/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.jfireel.expression.util;

import com.jfirer.baseutil.StringUtil;
import com.jfirer.jfireel.expression.node.CalculateNode;
import com.jfirer.jfireel.expression.node.QuestionNode;
import com.jfirer.jfireel.expression.node.impl.DivisionNode;
import com.jfirer.jfireel.expression.node.impl.DoubleAmpNode;
import com.jfirer.jfireel.expression.node.impl.DoubleBarNode;
import com.jfirer.jfireel.expression.node.impl.EqualNode;
import com.jfirer.jfireel.expression.node.impl.GtEqNode;
import com.jfirer.jfireel.expression.node.impl.GtNode;
import com.jfirer.jfireel.expression.node.impl.LtEqNode;
import com.jfirer.jfireel.expression.node.impl.LtNode;
import com.jfirer.jfireel.expression.node.impl.MinusNode;
import com.jfirer.jfireel.expression.node.impl.MutliNode;
import com.jfirer.jfireel.expression.node.impl.NotEqualNode;
import com.jfirer.jfireel.expression.node.impl.OperatorResultNode;
import com.jfirer.jfireel.expression.node.impl.PercentNode;
import com.jfirer.jfireel.expression.node.impl.PlusNode;
import com.jfirer.jfireel.expression.node.impl.QuestionNodeImpl;
import com.jfirer.jfireel.expression.token.Operator;
import com.jfirer.jfireel.expression.token.Token;
import com.jfirer.jfireel.expression.token.TokenType;
import java.util.LinkedList;
import java.util.List;

public class OperatorResultUtil {
    public static CalculateNode aggregate(List<CalculateNode> list, int function, String el, int offset) {
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.size() == 3) {
            if (Operator.class.isAssignableFrom(list.get(1).type().getClass())) {
                return OperatorResultUtil.buildOperatorResultNode(list.get(0), list.get(1), list.get(2), function);
            }
            throw new IllegalArgumentException(el.substring(0, offset));
        }
        if (list.size() >= 5) {
            TokenType type;
            int i = 0;
            while (i < list.size()) {
                type = list.get(i).type();
                if (type == Operator.MULTI || type == Operator.DIVISION || type == Operator.PERCENT) {
                    if (i > 0 && list.size() > i + 1 && !Operator.isOperator(list.get(i - 1).type()) && !Operator.isOperator(list.get(i + 1).type())) {
                        CalculateNode resultNode = OperatorResultUtil.buildOperatorResultNode(list.get(i - 1), list.get(i), list.get(i + 1), function);
                        list.remove(i - 1);
                        list.remove(i - 1);
                        list.remove(i - 1);
                        list.add(i - 1, resultNode);
                        continue;
                    }
                    throw new IllegalArgumentException(el.substring(0, offset));
                }
                ++i;
            }
            i = 0;
            while (i < list.size()) {
                type = list.get(i).type();
                if (type == Operator.QUESTION) {
                    if (i == 0) {
                        throw new IllegalArgumentException(StringUtil.format((String)"?\u64cd\u4f5c\u7b26\u524d\u9762\u5e94\u8be5\u6709\u64cd\u4f5c\u6570,\u95ee\u9898\u533a\u95f4:{}", (Object[])new Object[]{el.substring(0, offset)}));
                    }
                    CalculateNode pred = list.get(i - 1);
                    list.remove(i - 1);
                    list.remove(i - 1);
                    list.add(i - 1, OperatorResultUtil.buildQuestionNode(pred));
                    continue;
                }
                if (type == Operator.COLON) {
                    list.remove(i);
                    boolean find = false;
                    LinkedList<CalculateNode> tmp = new LinkedList<CalculateNode>();
                    for (int index = i - 1; index >= 0; --index) {
                        if (list.get(index).type() == Token.QUESTION) {
                            if (tmp.size() == 0) {
                                throw new IllegalArgumentException("?\u548c:\u4e4b\u95f4\u7f3a\u5c11\u6709\u6548\u8868\u8fbe\u5f0f,\u95ee\u9898\u533a\u95f4:" + el.substring(0, offset));
                            }
                            find = true;
                            CalculateNode leftNode = OperatorResultUtil.aggregate(tmp, function, el, offset);
                            ((QuestionNode)list.get(index)).setLeftNode(leftNode);
                            i = index + 1;
                            break;
                        }
                        tmp.add(0, list.get(index));
                        list.remove(index);
                    }
                    if (!find) {
                        throw new IllegalArgumentException("\u4e0d\u662f\u6709\u6548\u7684\u4e09\u5143\u8868\u8fbe\u5f0f\uff1a" + el.substring(0, offset));
                    }
                    if (i >= list.size()) {
                        throw new IllegalArgumentException("\u4e0d\u662f\u6709\u6548\u7684\u4e09\u5143\u8868\u8fbe\u5f0f\uff1a" + el.substring(0, offset));
                    }
                    ((QuestionNode)list.get(i - 1)).setRightNode(list.get(i));
                    list.remove(i);
                    continue;
                }
                if (Operator.isOperator(type)) {
                    if (i > 0 && list.size() > i + 1 && !Operator.isOperator(list.get(i - 1).type()) && !Operator.isOperator(list.get(i + 1).type())) {
                        CalculateNode resultNode = OperatorResultUtil.buildOperatorResultNode(list.get(i - 1), list.get(i), list.get(i + 1), function);
                        list.remove(i - 1);
                        list.remove(i - 1);
                        list.remove(i - 1);
                        list.add(i - 1, resultNode);
                        continue;
                    }
                    throw new IllegalArgumentException(el.substring(0, offset));
                }
                ++i;
            }
            if (list.size() != 1) {
                throw new IllegalArgumentException(el.substring(0, offset));
            }
            return list.get(0);
        }
        throw new IllegalArgumentException(el.substring(0, offset));
    }

    private static CalculateNode buildOperatorResultNode(CalculateNode leftNode, CalculateNode operatorNode, CalculateNode rightNode, int function) {
        OperatorResultNode resultNode = null;
        switch ((Operator)operatorNode.type()) {
            case PLUS: {
                resultNode = new PlusNode();
                break;
            }
            case MULTI: {
                resultNode = new MutliNode();
                break;
            }
            case EQ: {
                resultNode = new EqualNode();
                break;
            }
            case NOT_EQ: {
                resultNode = new NotEqualNode();
                break;
            }
            case MINUS: {
                resultNode = new MinusNode();
                break;
            }
            case DIVISION: {
                resultNode = new DivisionNode();
                break;
            }
            case GT: {
                resultNode = new GtNode();
                break;
            }
            case LT: {
                resultNode = new LtNode();
                break;
            }
            case PERCENT: {
                resultNode = new PercentNode();
                break;
            }
            case GT_EQ: {
                resultNode = new GtEqNode();
                break;
            }
            case LT_EQ: {
                resultNode = new LtEqNode();
                break;
            }
            case DOUBLE_AMP: {
                resultNode = new DoubleAmpNode();
                break;
            }
            case DOUBLE_BAR: {
                resultNode = new DoubleBarNode();
                break;
            }
            default: {
                throw new UnsupportedOperationException(((Operator)operatorNode.type()).toString());
            }
        }
        resultNode.setLeftOperand(leftNode);
        resultNode.setRightOperand(rightNode);
        return resultNode;
    }

    private static CalculateNode buildQuestionNode(CalculateNode conditionNode) {
        QuestionNodeImpl questionNode = new QuestionNodeImpl();
        questionNode.setConditionNode(conditionNode);
        return questionNode;
    }
}

