/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.jfireel.template.execution.impl;

import com.jfirer.jfireel.expression.Expression;
import com.jfirer.jfireel.template.execution.Execution;
import com.jfirer.jfireel.template.execution.WithBodyExecution;
import com.jfirer.jfireel.template.execution.impl.ElseExecution;
import com.jfirer.jfireel.template.execution.impl.ElseIfExecution;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class IfExecution
implements WithBodyExecution {
    private Expression conditionLexer;
    private Execution[] body;
    private Execution elseExecution;
    private List<Execution> elseIfExecutions = new LinkedList<Execution>();

    public IfExecution(Expression conditionLexer) {
        this.conditionLexer = conditionLexer;
    }

    @Override
    public boolean execute(Map<String, Object> variables, StringBuilder cache) {
        Object result = this.conditionLexer.calculate(variables);
        if (result == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u5b58\u5728\uff0c\u5bfc\u81f4\u65e0\u6cd5\u8ba1\u7b97\u6761\u4ef6\u8868\u8fbe\u5f0f");
        }
        if (((Boolean)result).booleanValue()) {
            for (Execution each : this.body) {
                each.execute(variables, cache);
            }
        } else {
            for (Execution execution : this.elseIfExecutions) {
                if (!execution.execute(variables, cache)) continue;
                return true;
            }
            if (this.elseExecution != null) {
                this.elseExecution.execute(variables, cache);
            }
        }
        return true;
    }

    public void addElseIf(ElseIfExecution execution) {
        this.elseIfExecutions.add(execution);
    }

    public void setElse(ElseExecution execution) {
        this.elseExecution = execution;
    }

    @Override
    public void check() {
    }

    @Override
    public void setBody(Execution ... executions) {
        this.body = executions;
    }

    @Override
    public boolean isBodyNotSet() {
        return this.body == null;
    }
}

