/*
 * Decompiled with CFR 0.152.
 */
package com.jgazula.easyresources.core.enhancedresourcebundle;

import com.jgazula.easyresources.core.enhancedresourcebundle.ERBBundleConfig;
import com.jgazula.easyresources.core.enhancedresourcebundle.ERBClassGenerator;
import com.jgazula.easyresources.core.enhancedresourcebundle.ERBConfig;
import com.jgazula.easyresources.core.enhancedresourcebundle.EnhancedResourceBundle;
import com.jgazula.easyresources.core.internal.classgeneration.ClassGeneratorConfig;
import com.jgazula.easyresources.core.internal.classgeneration.ClassGeneratorFactory;
import com.jgazula.easyresources.core.internal.properties.PropertiesParser;
import com.jgazula.easyresources.core.internal.properties.PropertiesReader;
import com.jgazula.easyresources.core.internal.util.StringUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ERBGenerator
implements EnhancedResourceBundle {
    private static final Logger LOGGER = LoggerFactory.getLogger(ERBGenerator.class);
    private final ERBConfig config;
    private final ClassGeneratorFactory generatorFactory;
    private final PropertiesReader propertiesReader;
    private final MessageFormat messageFormat;
    private final PropertiesParser propertiesParser;

    ERBGenerator(ERBConfig config, ClassGeneratorFactory generatorFactory, PropertiesReader propertiesReader, MessageFormat messageFormat, PropertiesParser propertiesParser) {
        this.config = config;
        this.generatorFactory = generatorFactory;
        this.propertiesReader = propertiesReader;
        this.messageFormat = messageFormat;
        this.propertiesParser = propertiesParser;
    }

    @Override
    public void generate() throws IOException {
        if (this.config.bundleConfigs().isEmpty()) {
            LOGGER.warn("No resource bundles have been configured. Skipping constants file generation.");
            return;
        }
        for (ERBBundleConfig bundleConfig : this.config.bundleConfigs()) {
            this.generateEnhancedResourceBundle(bundleConfig);
        }
    }

    private void generateEnhancedResourceBundle(ERBBundleConfig bundleConfig) throws IOException {
        LOGGER.debug("Generating enhanced resource bundle for {}", (Object)bundleConfig.bundlePath());
        TreeMap properties = new TreeMap();
        try (Stream<Path> files = this.propertiesReader.getResourceBundlePropertyFiles(bundleConfig.bundlePath(), bundleConfig.bundleName());){
            files.forEach(path -> {
                try {
                    properties.putAll(this.propertiesReader.loadProperties((Path)path));
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to load properties for file: " + path.toString(), e);
                }
            });
        }
        if (properties.isEmpty()) {
            LOGGER.warn("The resource bundle {} at path {} is empty. Skipping enhancing of resource bundle.", (Object)bundleConfig.bundleName(), (Object)bundleConfig.bundlePath());
        } else {
            ClassGeneratorConfig poetConfig = ClassGeneratorConfig.builder().generatedBy(this.config.generatedBy()).packageName(bundleConfig.generatedPackageName()).className(bundleConfig.generatedClassName()).build();
            ERBClassGenerator classGenerator = this.generatorFactory.getERBClassGenerator(poetConfig);
            classGenerator.initialize();
            for (Map.Entry entry : properties.entrySet()) {
                this.generateForKey(classGenerator, (String)entry.getKey(), (String)entry.getValue());
            }
            Path writtenPath = classGenerator.write(this.config.destinationDir());
            LOGGER.debug("Wrote enhanced resource bundle to {}", (Object)writtenPath);
            LOGGER.info("Generated enhanced resource bundle for {}", (Object)bundleConfig.bundleName());
        }
    }

    private void generateForKey(ERBClassGenerator classGenerator, String key, String value) {
        this.messageFormat.applyPattern(value);
        Format[] formats = this.messageFormat.getFormatsByArgumentIndex();
        List<Type> argTypes = Arrays.stream(formats).map(this::mapFormatToArgType).collect(Collectors.toList());
        classGenerator.addMethod(key, this.propertiesParser.keyToMethodName(key), argTypes);
    }

    private Type mapFormatToArgType(Format format) {
        if (format instanceof NumberFormat) {
            DecimalFormat decimalFormat;
            if (!(!(format instanceof DecimalFormat) || StringUtil.isNullOrEmpty((decimalFormat = (DecimalFormat)format).getPositivePrefix()) && StringUtil.isNullOrEmpty(decimalFormat.getPositiveSuffix()))) {
                return BigDecimal.class;
            }
            return Integer.TYPE;
        }
        if (format instanceof DateFormat) {
            return Date.class;
        }
        return String.class;
    }
}

