/*
 * Decompiled with CFR 0.152.
 */
package com.jgazula.easyresources.core.internal.classgeneration;

import com.jgazula.easyresources.core.internal.classgeneration.ClassGenerator;
import com.jgazula.easyresources.core.internal.classgeneration.ClassGeneratorConfig;
import com.jgazula.easyresources.core.internal.classgeneration.ClassGeneratorVariable;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoetClassGenerator
implements ClassGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PoetClassGenerator.class);
    private static final String INDENT = "    ";
    private static final String GENERATED_BY_COMMENT = "This class was auto generated by %s.";
    private final ClassGeneratorConfig config;
    private final List<FieldSpec> fieldSpecs = new ArrayList<FieldSpec>();
    private final List<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();

    public PoetClassGenerator(ClassGeneratorConfig config) {
        this.config = config;
    }

    @Override
    public ClassGenerator addPublicConstantString(String variableName, String variableValue) {
        FieldSpec fieldSpec = FieldSpec.builder(String.class, (String)variableName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{variableValue}).build();
        this.addFieldSpec(fieldSpec);
        return this;
    }

    @Override
    public ClassGenerator addPrivateFinalField(ClassGeneratorVariable field) {
        FieldSpec fieldSpec = FieldSpec.builder((Type)field.type(), (String)field.name(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        this.addFieldSpec(fieldSpec);
        return this;
    }

    @Override
    public ClassGenerator addConstructorWithArgs(List<ClassGeneratorVariable> args) {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        args.forEach(arg -> builder.addParameter(arg.type(), arg.name(), new Modifier[0]).addStatement("this.$N = $N", new Object[]{arg.name(), arg.name()}));
        MethodSpec methodSpec = builder.build();
        this.addMethodSpec(methodSpec);
        return this;
    }

    @Override
    public Path write(Path directory) throws IOException {
        TypeSpec typeSpec = TypeSpec.classBuilder((String)this.config.className()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addFields(this.fieldSpecs).addMethods(this.methodSpecs).build();
        String formattedTimestamp = ZonedDateTime.now().format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG));
        Path outputPath = JavaFile.builder((String)this.config.packageName(), (TypeSpec)typeSpec).addFileComment(String.format(GENERATED_BY_COMMENT, this.config.generatedBy()), new Object[0]).addFileComment("\n", new Object[0]).addFileComment(formattedTimestamp, new Object[0]).indent(INDENT).build().writeToPath(directory, StandardCharsets.UTF_8);
        LOGGER.debug("Wrote Java file for {}.{} to {}", new Object[]{this.config.packageName(), this.config.className(), outputPath});
        return outputPath;
    }

    protected void addFieldSpec(FieldSpec fieldSpec) {
        this.fieldSpecs.add(fieldSpec);
    }

    protected void addMethodSpec(MethodSpec methodSpec) {
        this.methodSpecs.add(methodSpec);
    }
}

