/*
 * Decompiled with CFR 0.152.
 */
package com.jgazula.easyresources.core.internal.properties;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class PropertiesReader {
    private static final String PROPERTIES_MATCHER_PATTERN_FORMAT = "%s.*\\.properties";

    public Map<String, String> loadProperties(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            Properties properties = new Properties();
            properties.load(reader);
            Properties properties2 = properties;
            return properties2;
        }
    }

    public Stream<Path> getResourceBundlePropertyFiles(Path bundlePath, String bundleName) throws IOException {
        Pattern propertiesPattern = Pattern.compile(String.format(PROPERTIES_MATCHER_PATTERN_FORMAT, bundleName));
        return Files.find(bundlePath, 1, (path, attrs) -> attrs.isRegularFile() && propertiesPattern.matcher(path.toFile().getName()).matches(), FileVisitOption.FOLLOW_LINKS);
    }
}

