/*
 * Decompiled with CFR 0.152.
 */
package com.jgazula.easyresources.core.propertiesconstants;

import com.jgazula.easyresources.core.internal.classgeneration.ClassGenerator;
import com.jgazula.easyresources.core.internal.classgeneration.ClassGeneratorConfig;
import com.jgazula.easyresources.core.internal.classgeneration.ClassGeneratorFactory;
import com.jgazula.easyresources.core.internal.properties.PropertiesParser;
import com.jgazula.easyresources.core.internal.properties.PropertiesReader;
import com.jgazula.easyresources.core.internal.util.FileUtil;
import com.jgazula.easyresources.core.propertiesconstants.PropertiesConstants;
import com.jgazula.easyresources.core.propertiesconstants.PropertiesConstantsConfig;
import com.jgazula.easyresources.core.propertiesconstants.PropertiesConstantsFileConfig;
import com.jgazula.easyresources.core.util.ValidationException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PCGenerator
implements PropertiesConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(PCGenerator.class);
    private final PropertiesConstantsConfig config;
    private final ClassGeneratorFactory generatorFactory;
    private final PropertiesReader propertiesReader;
    private final PropertiesParser propertiesParser;
    private final FileUtil fileUtil;

    PCGenerator(PropertiesConstantsConfig config, ClassGeneratorFactory generatorFactory, PropertiesReader propertiesReader, PropertiesParser propertiesParser, FileUtil fileUtil) {
        this.config = config;
        this.generatorFactory = generatorFactory;
        this.propertiesReader = propertiesReader;
        this.propertiesParser = propertiesParser;
        this.fileUtil = fileUtil;
    }

    @Override
    public void generate() throws IOException {
        if (this.config.fileConfigs().isEmpty()) {
            LOGGER.warn("No properties files have been configured. Skipping constants file generation.");
            return;
        }
        for (PropertiesConstantsFileConfig fileConfig : this.config.fileConfigs()) {
            this.generateFile(fileConfig);
        }
    }

    private void generateFile(PropertiesConstantsFileConfig fileConfig) throws IOException {
        LOGGER.debug("Generating constants file for {}", (Object)fileConfig.propertiesPath());
        if (!this.fileUtil.exists(fileConfig.propertiesPath())) {
            throw new ValidationException("File %s does not exist", fileConfig.propertiesPath().toString());
        }
        Map<String, String> properties = this.propertiesReader.loadProperties(fileConfig.propertiesPath());
        LOGGER.debug("Successfully loaded {} properties from {}", (Object)properties.size(), (Object)fileConfig.propertiesPath());
        if (properties.isEmpty()) {
            LOGGER.warn("The properties file {} is empty. Skipping constants file generation.", (Object)fileConfig.propertiesPath());
        } else {
            ClassGeneratorConfig poetConfig = ClassGeneratorConfig.builder().generatedBy(this.config.generatedBy()).packageName(fileConfig.generatedPackageName()).className(fileConfig.generatedClassName()).build();
            ClassGenerator generator = this.generatorFactory.getGenerator(poetConfig);
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                try {
                    String variableName = this.propertiesParser.keyToStaticFinalVariable(entry.getKey());
                    generator.addPublicConstantString(variableName, entry.getKey());
                }
                catch (IllegalArgumentException e) {
                    LOGGER.debug("Unable to parse or generate variable for key {} in file {}", new Object[]{entry.getKey(), fileConfig.propertiesPath().toFile(), e});
                    throw new ValidationException("Invalid property key %s in file %s", entry.getKey(), fileConfig.propertiesPath().toString());
                }
            }
            Path writtenPath = generator.write(this.config.destinationDir());
            LOGGER.debug("Wrote properties to {}", (Object)writtenPath);
            LOGGER.info("Generated constants file for {}", (Object)fileConfig.propertiesPath());
        }
    }
}

