/*
 * Decompiled with CFR 0.152.
 */
package com.jgeppert.struts2.jquery.components;

import com.jgeppert.struts2.jquery.components.AbstractFormElement;
import com.opensymphony.xwork2.util.ValueStack;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.util.ContainUtil;
import org.apache.struts2.util.MakeIterator;
import org.apache.struts2.views.annotations.StrutsTagAttribute;

public abstract class AbstractFormListElement
extends AbstractFormElement {
    private static final String PARAM_REMOTE_LIST = "remoteList";
    private static final String PARAM_REMOTE_LIST_KEY = "remoteListKey";
    private static final String PARAM_REMOTE_LIST_VALUE = "remoteListValue";
    protected boolean throwExceptionOnNullValueAttribute = false;
    protected Object list;
    protected String listKey;
    protected String listValue;

    public AbstractFormListElement(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    @Override
    public void evaluateExtraParams() {
        super.evaluateExtraParams();
        if (this.href != null && !this.href.equals("#")) {
            if (this.list != null) {
                this.addParameter(PARAM_REMOTE_LIST, this.findString(this.list.toString()));
            }
            if (this.listKey != null) {
                this.addParameter(PARAM_REMOTE_LIST_KEY, this.findString(this.listKey));
            }
            if (this.listValue != null) {
                this.addParameter(PARAM_REMOTE_LIST_VALUE, this.findString(this.listValue));
            }
        } else {
            Object value = null;
            if (this.list == null) {
                this.list = this.parameters.get("list");
            }
            if (this.list instanceof String) {
                value = this.findValue((String)this.list);
            } else if (this.list instanceof Collection) {
                value = this.list;
            } else if (MakeIterator.isIterable((Object)this.list)) {
                value = MakeIterator.convert((Object)this.list);
            }
            if (value == null) {
                value = this.throwExceptionOnNullValueAttribute ? this.findValue(this.list == null ? (String)this.list : this.list.toString(), "list", "The requested list key '" + this.list + "' could not be resolved as a collection/array/map/enumeration/iterator type. Example: people or people.{name}") : this.findValue(this.list == null ? (String)this.list : this.list.toString());
            }
            if (value instanceof Collection) {
                this.addParameter("list", value);
            } else {
                this.addParameter("list", MakeIterator.convert((Object)value));
            }
            if (value instanceof Collection) {
                this.addParameter("listSize", ((Collection)value).size());
            } else if (value instanceof Map) {
                this.addParameter("listSize", ((Map)value).size());
            } else if (value != null && value.getClass().isArray()) {
                this.addParameter("listSize", Array.getLength(value));
            }
            if (this.listKey != null) {
                this.addParameter("listKey", this.stripExpression(this.listKey));
            } else if (value instanceof Map) {
                this.addParameter("listKey", "key");
            }
            if (this.listValue != null) {
                this.addParameter("listValue", this.stripExpression(this.listValue));
            } else if (value instanceof Map) {
                this.addParameter("listValue", "value");
            }
        }
    }

    public boolean contains(Object obj1, Object obj2) {
        return ContainUtil.contains((Object)obj1, (Object)obj2);
    }

    protected Class getValueClassType() {
        return null;
    }

    @StrutsTagAttribute(description="Iterable source to populate from. If the list is a Map (key, value), the Map key will become the option 'value' parameter and the Map value will become the option body.", required=false)
    public void setList(Object list) {
        this.list = list;
    }

    @StrutsTagAttribute(description=" Property of list objects to get field value from")
    public void setListKey(String listKey) {
        this.listKey = listKey;
    }

    @StrutsTagAttribute(description="Property of list objects to get field content from")
    public void setListValue(String listValue) {
        this.listValue = listValue;
    }

    public void setThrowExceptionOnNullValueAttribute(boolean throwExceptionOnNullValueAttribute) {
        this.throwExceptionOnNullValueAttribute = throwExceptionOnNullValueAttribute;
    }
}

