/*
 * Decompiled with CFR 0.152.
 */
package com.jgeppert.struts2.jquery.components;

import com.jgeppert.struts2.jquery.components.AbstractTopicsBean;
import com.opensymphony.xwork2.util.ValueStack;
import java.util.Arrays;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;
import org.apache.struts2.views.annotations.StrutsTagSkipInheritance;

@StrutsTag(name="slider", tldTagClass="com.jgeppert.struts2.jquery.views.jsp.ui.SliderTag", description="Render a Slider", allowDynamicAttributes=true)
public class Slider
extends AbstractTopicsBean {
    public static final String JQUERYACTION = "slider";
    public static final String TEMPLATE = "slider";
    public static final String TEMPLATE_CLOSE = "slider-close";
    private static final String PARAM_ANIMATE = "animate";
    private static final String PARAM_MAX = "max";
    private static final String PARAM_MIN = "min";
    private static final String PARAM_ORIENTATION = "orientation";
    private static final String PARAM_STEP = "step";
    private static final String PARAM_DISPLAY_VALUE_ELEMENT = "displayValueElement";
    private static final String PARAM_ON_SLIDE_TOPICS = "onSlideTopics";
    private static final String PARAM_ARRAY_VALUE = "arrayValue";
    private static final String PARAM_RANGE = "range";
    private static final String PARAM_VALUE = "value";
    private static final String SUFFIX_WIDGET = "_widget";
    private static final String PARAM_WIDGETID = "widgetid";
    private static final String ID_PREFIX_SLIDER = "slider_";
    protected String animate;
    protected String max;
    protected String min;
    protected String orientation;
    protected String range;
    protected String step;
    protected String displayValueElement;
    protected String onSlideTopics;

    public Slider(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    public String getDefaultOpenTemplate() {
        return "slider";
    }

    protected String getDefaultTemplate() {
        return TEMPLATE_CLOSE;
    }

    public void evaluateParams() {
        super.evaluateParams();
        this.addParameter("jqueryaction", "slider");
        this.addParameterIfPresent(PARAM_ANIMATE, this.animate, Boolean.class);
        this.addParameterIfPresent(PARAM_MAX, this.max, Integer.class);
        this.addParameterIfPresent(PARAM_MIN, this.min, Integer.class);
        this.addParameterIfPresent(PARAM_ORIENTATION, this.orientation);
        this.addParameterIfPresent(PARAM_RANGE, this.range);
        this.addParameterIfPresent(PARAM_STEP, this.step, Integer.class);
        this.addParameterIfPresent(PARAM_DISPLAY_VALUE_ELEMENT, this.displayValueElement);
        this.addParameterIfPresent(PARAM_ON_SLIDE_TOPICS, this.onSlideTopics);
        Object valueObject = null;
        String strValue = null;
        if (this.value != null) {
            strValue = this.value;
        } else if (this.name != null) {
            strValue = this.name;
        }
        if (strValue != null) {
            valueObject = this.findValue(strValue);
        }
        if (valueObject == null && strValue != null) {
            valueObject = strValue;
        }
        if (valueObject != null) {
            if (valueObject instanceof String && ((String)valueObject).startsWith("[")) {
                this.addParameter(PARAM_ARRAY_VALUE, this.findString(strValue));
                this.addParameter(PARAM_RANGE, Boolean.TRUE.toString());
            } else if (valueObject instanceof Collection) {
                Collection col = (Collection)valueObject;
                if (col.size() >= 2) {
                    this.addParameter(PARAM_ARRAY_VALUE, Arrays.toString(col.toArray()));
                    this.addParameter(PARAM_RANGE, Boolean.TRUE.toString());
                }
            } else if (valueObject instanceof Object[]) {
                Object[] ary = (Object[])valueObject;
                if (ary.length >= 2) {
                    this.addParameter(PARAM_ARRAY_VALUE, Arrays.toString(ary));
                    this.addParameter(PARAM_RANGE, Boolean.TRUE.toString());
                }
            } else {
                this.addParameter(PARAM_VALUE, this.findString(strValue));
            }
        }
        this.addGeneratedIdParam(ID_PREFIX_SLIDER);
        this.addParameter("id", this.id + SUFFIX_WIDGET);
        this.addParameter("escapedId", this.escape(this.id) + SUFFIX_WIDGET);
        this.addParameter(PARAM_WIDGETID, this.id);
    }

    @StrutsTagSkipInheritance
    public void setTheme(String theme) {
        super.setTheme(theme);
    }

    public String getTheme() {
        return "jquery";
    }

    @StrutsTagAttribute(description="Whether to slide handle smoothly when user click outside handle on the bar. Default: false", defaultValue="false", type="Boolean")
    public void setAnimate(String animate) {
        this.animate = animate;
    }

    @StrutsTagAttribute(description="Initialize a slider with the max option specified. Default: 100", type="Integer")
    public void setMax(String max) {
        this.max = max;
    }

    @StrutsTagAttribute(description="The minimum value of the slider. Default: 0", type="Integer")
    public void setMin(String min) {
        this.min = min;
    }

    @StrutsTagAttribute(description="Normally you don't need to set this option because the plugin detects the slider orientation automatically. If the orientation is not correctly detected you can set this option to 'horizontal' or 'vertical'. Default: 'auto'")
    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    @StrutsTagAttribute(description="If set to true, the slider will detect if you have two handles and create a stylable range element between these two. Two other possible values are 'min' and 'max'. A min range goes from the slider min to one handle. A max range goes from one handle to the slider max.")
    public void setRange(String range) {
        this.range = range;
    }

    @StrutsTagAttribute(description="Determines the size or amount of each interval or step the slider takes between min and max. The full specified value range of the slider (max - min) needs to be evenly divisible by the step. Default: 1", type="Integer")
    public void setStep(String step) {
        this.step = step;
    }

    @StrutsTagAttribute(description="Determines the value of the slider. Default: 0")
    public void setValue(String value) {
        super.setValue(value);
    }

    @StrutsTagAttribute(description="Element Id to display the value.")
    public void setDisplayValueElement(String displayValueElement) {
        this.displayValueElement = displayValueElement;
    }

    @StrutsTagAttribute(description="A comma delimited list of topics that published when slide")
    public void setOnSlideTopics(String onSlideTopics) {
        this.onSlideTopics = onSlideTopics;
    }
}

