/*
 * Decompiled with CFR 0.152.
 */
package com.jgeppert.struts2.jquery.components;

import com.jgeppert.struts2.jquery.components.AbstractRemoteBean;
import com.jgeppert.struts2.jquery.components.TabbedPanel;
import com.opensymphony.xwork2.util.ValueStack;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;
import org.apache.struts2.views.annotations.StrutsTagSkipInheritance;

@StrutsTag(name="tab", tldTagClass="com.jgeppert.struts2.jquery.views.jsp.ui.TabTag", description="Render Tab for Tabbed Panel providing content from remote call via AJAX")
public class Tab
extends AbstractRemoteBean {
    public static final String TEMPLATE = "tab";
    public static final String TEMPLATE_CLOSE = "tab-close";
    public static final String COMPONENT_NAME = Tab.class.getName();
    private static final String PARAM_PARENT_TABBED_PANEL = "parentTabbedPanel";
    private static final String PARAM_TARGET = "target";
    private static final String PARAM_CLOSABLE = "closable";
    private static final String ID_PREFIX_TAB = "tab_";
    protected String target;
    protected String closable;

    public Tab(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    public String getDefaultOpenTemplate() {
        return TEMPLATE;
    }

    protected String getDefaultTemplate() {
        return TEMPLATE_CLOSE;
    }

    @Override
    public void evaluateExtraParams() {
        super.evaluateExtraParams();
        TabbedPanel parentTabbedPanel = (TabbedPanel)this.findAncestor(TabbedPanel.class);
        if (parentTabbedPanel != null) {
            this.addParameter(PARAM_PARENT_TABBED_PANEL, this.findString(parentTabbedPanel.getId()));
        }
        this.addParameterIfPresent(PARAM_CLOSABLE, this.closable, Boolean.class);
        this.addParameterIfPresent(PARAM_TARGET, this.target);
        this.addGeneratedIdParam(ID_PREFIX_TAB);
    }

    @StrutsTagSkipInheritance
    public void setTheme(String theme) {
        super.setTheme(theme);
    }

    public String getTheme() {
        return "jquery";
    }

    @StrutsTagAttribute(description="id of target div for tab")
    public void setTarget(String target) {
        this.target = target;
    }

    @StrutsTagAttribute(description="If true then tab is closable.", defaultValue="false", type="Boolean")
    public void setClosable(String closable) {
        this.closable = closable;
    }
}

