/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.aws.lambda.support.interceptors;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ModelDriven;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.rest.ContentTypeHandlerManager;
import org.apache.struts2.rest.handler.ContentTypeHandler;

public class LambdaRestContentTypeInterceptor
extends AbstractInterceptor {
    private static final Logger log = LogManager.getLogger(LambdaRestContentTypeInterceptor.class);
    private static final long serialVersionUID = 7353444754536750933L;
    private ContentTypeHandlerManager selector;

    @Inject
    public void setContentTypeHandlerSelector(ContentTypeHandlerManager sel) {
        this.selector = sel;
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        ContentTypeHandler handler = this.selector.getHandlerForRequest(request);
        log.debug("Found content type handler for request: {}", (Object)handler);
        Object target = invocation.getAction();
        if (target instanceof ModelDriven) {
            target = ((ModelDriven)target).getModel();
        }
        if (request.getContentLength() > 0) {
            ServletInputStream is = request.getInputStream();
            InputStreamReader reader = new InputStreamReader((InputStream)is);
            handler.toObject(invocation, (Reader)reader, target);
        } else if (this.requestHasBody(request)) {
            String body = IOUtils.toString((Reader)request.getReader());
            handler.toObject(invocation, (Reader)new StringReader(body), target);
        }
        return invocation.invoke();
    }

    private boolean requestHasBody(HttpServletRequest request) throws IOException {
        return ("POST".equalsIgnoreCase(request.getMethod()) || "PUT".equalsIgnoreCase(request.getMethod())) && request.getReader() != null;
    }
}

