/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.aws.lambda.support.interceptors;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.MethodFilterInterceptor;
import java.io.OutputStream;
import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExceptionHandlerInterceptor
extends MethodFilterInterceptor {
    private static final Logger log = LogManager.getLogger(ExceptionHandlerInterceptor.class);
    private static final String ACTION_ERROR = "actionError";
    private static ObjectMapper mapper = new ObjectMapper();

    protected String doIntercept(ActionInvocation actionInvocation) throws Exception {
        try {
            return actionInvocation.invoke();
        }
        catch (Exception exception) {
            HashMap<String, String> errors = new HashMap<String, String>();
            int statusCode = 400;
            if (exception instanceof SecurityException) {
                errors.put(ACTION_ERROR, "Operation not allowed!");
                statusCode = 403;
            } else {
                errors.put(ACTION_ERROR, exception.getMessage());
            }
            HttpServletResponse response = (HttpServletResponse)actionInvocation.getInvocationContext().get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
            response.setStatus(statusCode);
            response.addHeader("X-Struts-StatusCode", "" + statusCode);
            mapper.writeValue((OutputStream)response.getOutputStream(), errors);
            return "error";
        }
    }
}

