/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.aws.lambda.support.interceptors;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.ValidationAware;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Validator;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.beanvalidation.validation.interceptor.BeanValidationInterceptor;
import org.apache.struts2.interceptor.validation.SkipValidation;

public class LambdaBeanValidationInterceptor
extends BeanValidationInterceptor {
    private static final Logger log = LogManager.getLogger(LambdaBeanValidationInterceptor.class);
    private int validationFailureStatusCode = 406;

    @Inject(value="struts.rest.validationFailureStatusCode", required=false)
    public void setValidationFailureStatusCode(String validationFailureStatusCode) {
        this.validationFailureStatusCode = Integer.parseInt(validationFailureStatusCode);
    }

    protected String doIntercept(ActionInvocation invocation) throws Exception {
        Validator validator = this.beanValidationManager.getValidator();
        if (validator == null) {
            log.debug("There is no Bean Validator configured in class path. Skipping Bean validation..");
            return invocation.invoke();
        }
        log.debug("Starting bean validation using validator: {}", validator.getClass());
        Object action = invocation.getAction();
        ActionProxy actionProxy = invocation.getProxy();
        String methodName = actionProxy.getMethod();
        log.debug("Validating [{}/{}] with method [{}]", (Object)invocation.getProxy().getNamespace(), (Object)invocation.getProxy().getActionName(), (Object)methodName);
        if (null == MethodUtils.getAnnotation((Method)this.getActionMethod(action.getClass(), methodName), SkipValidation.class, (boolean)true, (boolean)true)) {
            Class[] validationGroup = this.getValidationGroups(action, methodName);
            this.performBeanValidation(action, validator, validationGroup);
        }
        if (action instanceof ValidationAware && ((ValidationAware)action).hasErrors()) {
            HttpServletResponse response = (HttpServletResponse)invocation.getInvocationContext().get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
            response.setStatus(this.validationFailureStatusCode);
            return "input";
        }
        return invocation.invoke();
    }
}

