/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.aws.lambda.support.result;

import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.config.entities.ResultTypeConfig;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.finder.ResourceFinder;
import com.opensymphony.xwork2.util.finder.Test;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.convention.DefaultResultMapBuilder;

public class LambdaResultMapBuilder
extends DefaultResultMapBuilder {
    private static final Logger log = LogManager.getLogger(LambdaResultMapBuilder.class);

    @Inject
    public LambdaResultMapBuilder(ServletContext servletContext, Container container, @Inject(value="struts.convention.relative.result.types") String relativeResultTypes) {
        super(servletContext, container, relativeResultTypes);
    }

    protected void createFromResources(Class<?> actionClass, Map<String, ResultConfig> results, String resultPath, String resultPrefix, String actionName, PackageConfig packageConfig, Map<String, ResultTypeConfig> resultsByExtension) {
        String classPathLocation;
        if (log.isTraceEnabled()) {
            log.trace("Searching for results in the Servlet container at [{}] with result prefix of {}", (Object)resultPath, (Object)resultPrefix);
        }
        String string = classPathLocation = resultPath.startsWith("/") ? resultPath.substring(1, resultPath.length()) : resultPath;
        if (log.isTraceEnabled()) {
            log.trace("Searching for results in the class path at [{}] with a result prefix of [{}] and action name [{}]", (Object)classPathLocation, (Object)resultPrefix, (Object)actionName);
        }
        ResourceFinder finder = new ResourceFinder(classPathLocation, this.getClassLoaderInterface());
        try {
            Map matches = finder.getResourcesMap("");
            if (matches != null) {
                Test<URL> resourceTest = this.getResourceTest(resultPath, actionName);
                for (Map.Entry entry : matches.entrySet()) {
                    if (!resourceTest.test(entry.getValue())) continue;
                    log.trace("Processing URL [{}]", entry.getKey());
                    String urlStr = ((URL)entry.getValue()).toString();
                    int index = urlStr.lastIndexOf(resultPrefix);
                    String path = urlStr.substring(index);
                    this.makeResults(actionClass, path, resultPrefix, results, packageConfig, resultsByExtension);
                }
            }
        }
        catch (IOException ex) {
            log.error("Unable to scan directory [{}] for results", (Object)ex, (Object)classPathLocation);
        }
    }

    private Test<URL> getResourceTest(String resultPath, String actionName) {
        return url -> {
            String urlStr = url.toString();
            int index = urlStr.lastIndexOf(resultPath);
            String path = urlStr.substring(index + resultPath.length());
            return path.startsWith(actionName);
        };
    }
}

