/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedArrayList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 3835017332487313880L;
    private Map<Object, IntegerWrapper> _indexCache;
    private boolean _lazyCaching = false;
    private boolean _isDirty = false;

    public CachedArrayList() {
    }

    public CachedArrayList(Collection<? extends E> c) {
        super(c);
        if (!this.isLazyCaching()) {
            this.cacheAll();
        }
    }

    public CachedArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public int indexOf(Object elem) {
        IntegerWrapper o;
        if (this._indexCache == null || this._isDirty) {
            this.cacheAll();
        }
        if ((o = this._indexCache.get(elem)) != null) {
            return o.integer;
        }
        if (this.isLazyCaching()) {
            int i = super.indexOf(elem);
            if (i == -1) {
                this.uncacheIt(elem);
            } else {
                this.cacheIt(elem, i);
            }
            return i;
        }
        return -1;
    }

    @Deprecated
    protected synchronized void adjustCache(int index, int increase) {
        if (this._indexCache != null) {
            Collection<IntegerWrapper> values = this._indexCache.values();
            for (IntegerWrapper value : values) {
                if (value.integer < index) continue;
                value.integer += increase;
            }
        }
    }

    protected Map<Object, IntegerWrapper> createCache() {
        return new IdentityHashMap<Object, IntegerWrapper>();
    }

    public void cacheIt(Object o, int index) {
        if (this._indexCache != null) {
            IntegerWrapper old = this._indexCache.put(o, new IntegerWrapper(index));
            if (old != null && old.integer < index) {
                this._indexCache.put(o, old);
            }
            this.markDirtyIfNecessary(index);
            if (!this._isDirty && !this.isLazyCaching()) {
                for (int i = this.size() - 1; i > index; --i) {
                    IntegerWrapper oldI = this._indexCache.put(this.get(i), new IntegerWrapper(i));
                    if (oldI == null || oldI.integer >= index) continue;
                    this._indexCache.put(this.get(i), oldI);
                }
            }
        }
    }

    protected void markDirtyIfNecessary(int index) {
        if (index < this.size() / 2) {
            this._isDirty = true;
        }
    }

    public void uncacheIt(Object o) {
        if (this._indexCache != null) {
            this._indexCache.remove(o);
        }
    }

    @Override
    public boolean add(E o) {
        boolean added = super.add(o);
        if (!this.isLazyCaching() && this._indexCache != null && added) {
            this.cacheIt(o, this.size() - 1);
        }
        return added;
    }

    @Override
    public void add(int index, E element) {
        if (index == this.size()) {
            this.add(element);
            return;
        }
        super.add(index, element);
        if (!this.isLazyCaching()) {
            this.cacheIt(element, index);
        } else if (this._indexCache != null) {
            this.cacheIt(element, index);
        }
    }

    private void initializeCache() {
        if (this._indexCache == null) {
            this._indexCache = this.createCache();
        }
    }

    @Override
    public E remove(int index) {
        Object element = super.remove(index);
        if (element != null) {
            this.uncacheAll();
        }
        return element;
    }

    @Override
    public boolean remove(Object o) {
        boolean removed = super.remove(o);
        if (removed) {
            this.uncacheAll();
        }
        return removed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.uncacheAll();
        return super.removeAll(c);
    }

    @Override
    public void clear() {
        this.uncacheAll();
        super.clear();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        int index = this.size();
        boolean added = super.addAll(c);
        if (added && this._indexCache != null) {
            for (E e : c) {
                this.cacheIt(e, index++);
            }
        }
        return added;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        if (index == this.size()) {
            return this.addAll(c);
        }
        boolean added = super.addAll(index, c);
        if (added) {
            this.uncacheAll();
        }
        return added;
    }

    @Override
    public E set(int index, E element) {
        if (!this.isLazyCaching()) {
            this.uncacheAll();
            return super.set(index, element);
        }
        return super.set(index, element);
    }

    public void invalidateCache() {
        this.uncacheAll();
    }

    public void uncacheAll() {
        if (this._indexCache != null) {
            this._indexCache.clear();
            this._indexCache = null;
        }
    }

    public void cacheAll() {
        this._indexCache = this.createCache();
        for (int i = this.size() - 1; i >= 0; --i) {
            this._indexCache.put(this.get(i), new IntegerWrapper(i));
        }
        this._isDirty = false;
    }

    public boolean isLazyCaching() {
        return this._lazyCaching;
    }

    public void setLazyCaching(boolean lazyCaching) {
        this._lazyCaching = lazyCaching;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            this.remove(fromIndex);
        } else {
            super.removeRange(fromIndex, toIndex);
            this.uncacheAll();
        }
    }

    public static class IntegerWrapper {
        int integer;

        private IntegerWrapper(int integer) {
            this.integer = integer;
        }
    }
}

