/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.awt.Color;
import java.awt.Image;
import java.util.Calendar;
import java.util.Date;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeUtils {
    private static final int WRAPPER_TYPE_INDEX = 0;
    private static final int PRIMITIVE_TYPE_INDEX = 1;
    private static final int PRIMITIVE_TYPE_KEY_INDEX = 2;
    private static final Object[][] PRIMITIVE_ARRAY_TYPES = new Object[][]{{Boolean.class, Boolean.TYPE, "Z"}, {Character.class, Character.TYPE, "C"}, {Byte.class, Byte.TYPE, "B"}, {Short.class, Short.TYPE, "S"}, {Integer.class, Integer.TYPE, "I"}, {Long.class, Long.TYPE, "J"}, {Float.class, Float.TYPE, "F"}, {Double.class, Double.TYPE, "D"}};

    public static boolean isPrimitive(Class<?> primitive) {
        for (Object[] primitiveArrayType : PRIMITIVE_ARRAY_TYPES) {
            if (primitiveArrayType[1] != primitive) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimitiveWrapper(Class<?> wrapperType) {
        for (Object[] primitiveArrayType : PRIMITIVE_ARRAY_TYPES) {
            if (primitiveArrayType[0] != wrapperType) continue;
            return true;
        }
        return false;
    }

    public static Class<?> convertPrimitiveToWrapperType(Class<?> primitive) {
        for (Object[] primitiveArrayType : PRIMITIVE_ARRAY_TYPES) {
            if (primitiveArrayType[1] != primitive) continue;
            return (Class)primitiveArrayType[0];
        }
        return primitive;
    }

    public static Class<?> convertWrapperToPrimitiveType(Class<?> wrapperType) {
        for (Object[] primitiveArrayType : PRIMITIVE_ARRAY_TYPES) {
            if (primitiveArrayType[0] != wrapperType) continue;
            return (Class)primitiveArrayType[1];
        }
        return wrapperType;
    }

    public static boolean isNumericType(Class<?> type) {
        return type != null && (Number.class.isAssignableFrom(type) || type == Double.TYPE || type == Integer.TYPE || type == Float.TYPE || type == Short.TYPE || type == Long.TYPE);
    }

    public static boolean isIntegerType(Class<?> type) {
        return type != null && (Integer.class.isAssignableFrom(type) || type == Integer.TYPE);
    }

    public static boolean isStringType(Class<?> type) {
        return type != null && String.class.isAssignableFrom(type);
    }

    public static boolean isBooleanType(Class<?> type) {
        return type != null && (Boolean.class.isAssignableFrom(type) || type == Boolean.TYPE);
    }

    public static boolean isTemporalType(Class<?> type) {
        return type != null && (Date.class.isAssignableFrom(type) || Calendar.class.isAssignableFrom(type) || type == Double.TYPE || type == Long.TYPE);
    }

    public static boolean isVisualType(Class<?> type) {
        return type != null && (Color.class.isAssignableFrom(type) || Icon.class.isAssignableFrom(type) || Image.class.isAssignableFrom(type));
    }
}

