/*
 * Decompiled with CFR 0.152.
 */
package com.jimmoores.quandl;

import com.jimmoores.quandl.Frequency;
import com.jimmoores.quandl.SortOrder;
import com.jimmoores.quandl.Transform;
import com.jimmoores.quandl.util.ArgumentChecker;
import javax.ws.rs.client.WebTarget;
import org.threeten.bp.LocalDate;

public final class DataSetRequest {
    private static final String START_DATE_PARAM = "trim_start";
    private static final String END_DATE_PARAM = "trim_end";
    private static final String COLUMN_INDEX_PARAM = "column";
    private static final String FREQUENCY_PARAM = "collapse";
    private static final String MAX_ROWS_PARAM = "rows";
    private static final String TRANSFORM_PARAM = "transformation";
    private static final String SORT_ORDER_PARAM = "sort_order";
    private static final String EXTENSION = ".csv";
    private static final String DATASETS_RELATIVE_URL = "datasets";
    private final String _quandlCode;
    private LocalDate _startDate;
    private LocalDate _endDate;
    private Integer _columnIndex;
    private Frequency _frequency;
    private Integer _maxRows;
    private Transform _transform;
    private SortOrder _sortOrder;

    private DataSetRequest(Builder builder) {
        this._quandlCode = builder._quandlCode;
        this._startDate = builder._startDate;
        this._endDate = builder._endDate;
        this._columnIndex = builder._columnIndex;
        this._frequency = builder._frequency;
        this._maxRows = builder._maxRows;
        this._transform = builder._transform;
        this._sortOrder = builder._sortOrder;
    }

    public String getQuandlCode() {
        return this._quandlCode;
    }

    public Frequency getFrequency() {
        return this._frequency;
    }

    public WebTarget appendPathAndQueryParameters(WebTarget webTarget) {
        ArgumentChecker.notNull(webTarget, "webTarget");
        WebTarget resultTarget = webTarget;
        resultTarget = resultTarget.path(DATASETS_RELATIVE_URL);
        resultTarget = resultTarget.path(this._quandlCode + EXTENSION);
        if (this._startDate != null) {
            resultTarget = resultTarget.queryParam(START_DATE_PARAM, new Object[]{this._startDate.toString()});
        }
        if (this._endDate != null) {
            resultTarget = resultTarget.queryParam(END_DATE_PARAM, new Object[]{this._endDate.toString()});
        }
        if (this._columnIndex != null) {
            resultTarget = resultTarget.queryParam(COLUMN_INDEX_PARAM, new Object[]{this._columnIndex});
        }
        if (this._frequency != null) {
            resultTarget = resultTarget.queryParam(FREQUENCY_PARAM, new Object[]{this._frequency.getQuandlString()});
        }
        if (this._maxRows != null) {
            resultTarget = resultTarget.queryParam(MAX_ROWS_PARAM, new Object[]{this._maxRows});
        }
        if (this._transform != null) {
            resultTarget = resultTarget.queryParam(TRANSFORM_PARAM, new Object[]{this._transform.getQuandlString()});
        }
        if (this._sortOrder != null) {
            resultTarget = resultTarget.queryParam(SORT_ORDER_PARAM, new Object[]{this._sortOrder.getQuandlString()});
        }
        return resultTarget;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this._frequency != null) {
            result = 31 * result + this._frequency.hashCode();
        }
        if (this._columnIndex != null) {
            result = 31 * result + this._columnIndex.hashCode();
        }
        if (this._maxRows != null) {
            result = 31 * result + this._maxRows.hashCode();
        }
        if (this._transform != null) {
            result = 31 * result + this._transform.hashCode();
        }
        if (this._sortOrder != null) {
            result = 31 * result + this._sortOrder.hashCode();
        }
        if (this._endDate != null) {
            result = 31 * result + this._endDate.hashCode();
        }
        if (this._startDate != null) {
            result = 31 * result + this._startDate.hashCode();
        }
        if (this._quandlCode != null) {
            result = 31 * result + this._quandlCode.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetRequest)) {
            return false;
        }
        DataSetRequest other = (DataSetRequest)obj;
        if (this._quandlCode == null ? other._quandlCode != null : !this._quandlCode.equals(other._quandlCode)) {
            return false;
        }
        if (this._columnIndex == null ? other._columnIndex != null : !this._columnIndex.equals(other._columnIndex)) {
            return false;
        }
        if (this._endDate == null ? other._endDate != null : !this._endDate.equals((Object)other._endDate)) {
            return false;
        }
        if (this._frequency != other._frequency) {
            return false;
        }
        if (this._maxRows == null ? other._maxRows != null : !this._maxRows.equals(other._maxRows)) {
            return false;
        }
        if (this._sortOrder != other._sortOrder) {
            return false;
        }
        if (this._startDate == null ? other._startDate != null : !this._startDate.equals((Object)other._startDate)) {
            return false;
        }
        return this._transform == other._transform;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DataSetRequest[quandlCode=");
        builder.append(this._quandlCode);
        builder.append(", startDate=");
        builder.append(this._startDate);
        builder.append(", endDate=");
        builder.append(this._endDate);
        builder.append(", columnIndex=");
        builder.append(this._columnIndex);
        builder.append(", frequency=");
        builder.append((Object)this._frequency);
        builder.append(", maxRows=");
        builder.append(this._maxRows);
        builder.append(", transform=");
        builder.append((Object)this._transform);
        builder.append(", sortOrder=");
        builder.append((Object)this._sortOrder);
        builder.append("]");
        return builder.toString();
    }

    public static final class Builder {
        private final String _quandlCode;
        private LocalDate _startDate;
        private LocalDate _endDate;
        private Integer _columnIndex;
        private Frequency _frequency;
        private Integer _maxRows;
        private Transform _transform;
        private SortOrder _sortOrder;

        private Builder(String quandlCode) {
            this._quandlCode = quandlCode;
        }

        public static Builder of(String quandlCode) {
            ArgumentChecker.notNull(quandlCode, "quandlCode");
            return new Builder(quandlCode);
        }

        public Builder withStartDate(LocalDate startDate) {
            ArgumentChecker.notNull(startDate, "startDate");
            this._startDate = startDate;
            return this;
        }

        public Builder withEndDate(LocalDate endDate) {
            ArgumentChecker.notNull(endDate, "endDate");
            this._endDate = endDate;
            return this;
        }

        public Builder withColumn(int columnIndex) {
            this._columnIndex = columnIndex;
            return this;
        }

        public Builder withFrequency(Frequency frequency) {
            ArgumentChecker.notNull((Object)frequency, "frequency");
            this._frequency = frequency;
            return this;
        }

        public Builder withMaxRows(int maxRows) {
            this._maxRows = maxRows;
            return this;
        }

        public Builder withTransform(Transform transform) {
            ArgumentChecker.notNull((Object)transform, "transform");
            this._transform = transform;
            return this;
        }

        public Builder withSortOrder(SortOrder sortOrder) {
            ArgumentChecker.notNull((Object)sortOrder, "sortOrder");
            this._sortOrder = sortOrder;
            return this;
        }

        public DataSetRequest build() {
            return new DataSetRequest(this);
        }
    }
}

