/*
 * Decompiled with CFR 0.152.
 */
package com.jimmoores.quandl;

import com.jimmoores.quandl.util.ArgumentChecker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HeaderDefinition {
    private static Logger s_logger = LoggerFactory.getLogger(HeaderDefinition.class);
    private final Map<String, Integer> _columnNamesToIndices = new LinkedHashMap<String, Integer>();
    private final List<String> _columnNames;

    private HeaderDefinition(List<String> columnNames) {
        this._columnNames = new ArrayList<String>(columnNames);
        int i = 0;
        HashMap<String, Integer> duplicateCounters = new HashMap<String, Integer>();
        for (String columnName : columnNames) {
            if (this._columnNamesToIndices.containsKey(columnName)) {
                int count;
                if (duplicateCounters.containsKey(columnName)) {
                    count = (Integer)duplicateCounters.get(columnName);
                    duplicateCounters.put(columnName, count + 1);
                } else {
                    duplicateCounters.put(columnName, 1);
                    count = 1;
                }
                String arrayColumnName = columnName + "." + count;
                s_logger.warn("Duplicate column name {} enountered, renaming {}", (Object)columnName, (Object)arrayColumnName);
                this._columnNamesToIndices.put(arrayColumnName, i);
                this._columnNames.set(i, arrayColumnName);
                ++i;
                continue;
            }
            this._columnNamesToIndices.put(columnName, i++);
        }
    }

    public static HeaderDefinition of(List<String> columnNames) {
        ArgumentChecker.notNull(columnNames, "columnNames");
        return new HeaderDefinition(columnNames);
    }

    public static HeaderDefinition of(String ... columnNames) {
        ArgumentChecker.notNull(columnNames, "columnNames");
        return new HeaderDefinition(Arrays.asList(columnNames));
    }

    public int columnIndex(String columnName) {
        Integer index = this._columnNamesToIndices.get(columnName);
        if (index == null) {
            throw new IllegalArgumentException("Could not find index for column " + columnName);
        }
        return index;
    }

    public int size() {
        return this._columnNames.size();
    }

    public Iterator<String> iterator() {
        return this.getColumnNames().iterator();
    }

    public List<String> getColumnNames() {
        return Collections.unmodifiableList(this._columnNames);
    }

    public int hashCode() {
        return this._columnNames.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HeaderDefinition)) {
            return false;
        }
        HeaderDefinition other = (HeaderDefinition)obj;
        return !(this._columnNames == null ? other._columnNames != null : !this._columnNames.equals(other._columnNames));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HeaderDefinition[");
        Iterator<String> iter = this._columnNames.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }
}

