/*
 * Decompiled with CFR 0.152.
 */
package com.jimmoores.quandl;

import com.jimmoores.quandl.util.ArgumentChecker;
import javax.ws.rs.client.WebTarget;

public final class MetaDataRequest {
    private static final String EXTENSION = ".json";
    private static final String DATASETS_RELATIVE_URL = "datasets";
    private static final String EXCLUDE_DATA_PARAM = "exclude_data";
    private String _quandlCode;

    private MetaDataRequest(String quandlCode) {
        this._quandlCode = quandlCode;
    }

    public static MetaDataRequest of(String quandlCode) {
        ArgumentChecker.notNull(quandlCode, "quandlCode");
        return new MetaDataRequest(quandlCode);
    }

    public String getQuandlCode() {
        return this._quandlCode;
    }

    public WebTarget appendPathAndQueryParameters(WebTarget webTarget) {
        ArgumentChecker.notNull(webTarget, "webTarget");
        WebTarget resultTarget = webTarget;
        resultTarget = resultTarget.path(DATASETS_RELATIVE_URL);
        resultTarget = resultTarget.path(this._quandlCode + EXTENSION);
        resultTarget = resultTarget.queryParam(EXCLUDE_DATA_PARAM, new Object[]{Boolean.TRUE.toString()});
        return resultTarget;
    }

    public int hashCode() {
        return this._quandlCode.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetaDataRequest)) {
            return false;
        }
        MetaDataRequest other = (MetaDataRequest)obj;
        return this._quandlCode.equals(other._quandlCode);
    }

    public String toString() {
        return "MetaDataRequest[quandlCode=" + this._quandlCode + "]";
    }
}

