/*
 * Decompiled with CFR 0.152.
 */
package com.jimmoores.quandl;

import com.jimmoores.quandl.HeaderDefinition;
import com.jimmoores.quandl.util.ArgumentChecker;
import com.jimmoores.quandl.util.PrettyPrinter;
import com.jimmoores.quandl.util.QuandlRuntimeException;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.format.DateTimeFormatter;

public final class MetaDataResult {
    private static Logger s_logger = LoggerFactory.getLogger(MetaDataResult.class);
    private static final String COLUMN_NAMES_FIELD = "column_names";
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ISO_DATE;
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    private static final String DATA_SOURCE_FIELD = "source_code";
    private static final String CODE_FIELD = "code";
    private JSONObject _jsonObject;

    private MetaDataResult(JSONObject jsonObject) {
        this._jsonObject = jsonObject;
    }

    public static MetaDataResult of(JSONObject jsonObject) {
        ArgumentChecker.notNull(jsonObject, "jsonObject");
        return new MetaDataResult(jsonObject);
    }

    public HeaderDefinition getHeaderDefinition() {
        JSONArray jsonArray = null;
        try {
            jsonArray = this._jsonObject.getJSONArray(COLUMN_NAMES_FIELD);
            ArrayList<String> columnNames = new ArrayList<String>(jsonArray.length());
            for (int i = 0; i < jsonArray.length(); ++i) {
                columnNames.add(jsonArray.getString(i));
            }
            return HeaderDefinition.of(columnNames);
        }
        catch (JSONException ex) {
            s_logger.error("Metadata had unexpected structure - could not extra column_names field, was:\n{}", (Object)this._jsonObject.toString());
            throw new QuandlRuntimeException("Metadata had unexpected structure", ex);
        }
    }

    public String getQuandlCode() {
        try {
            String dataSourceField = this.getString(DATA_SOURCE_FIELD);
            String codeField = this.getString(CODE_FIELD);
            return dataSourceField + "/" + codeField;
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    public String getString(String fieldName) {
        try {
            return this._jsonObject.getString(fieldName);
        }
        catch (JSONException ex) {
            throw new RuntimeException("Cannot find field", ex);
        }
    }

    public LocalDate getLocalDate(String fieldName) {
        try {
            if (this._jsonObject.isNull(fieldName)) {
                return null;
            }
            return LocalDate.parse((CharSequence)this._jsonObject.getString(fieldName), (DateTimeFormatter)DATE_FORMATTER);
        }
        catch (JSONException ex) {
            throw new QuandlRuntimeException("Cannot find field", ex);
        }
    }

    public OffsetDateTime getOffsetDateTime(String fieldName) {
        try {
            if (this._jsonObject.isNull(fieldName)) {
                return null;
            }
            return OffsetDateTime.parse((CharSequence)this._jsonObject.getString(fieldName), (DateTimeFormatter)DATE_TIME_FORMATTER);
        }
        catch (JSONException ex) {
            throw new QuandlRuntimeException("Cannot find field", ex);
        }
    }

    public boolean has(String fieldName) {
        return this._jsonObject.has(fieldName);
    }

    public Double getDouble(String fieldName) {
        try {
            if (this._jsonObject.isNull(fieldName)) {
                return null;
            }
            return this._jsonObject.getDouble(fieldName);
        }
        catch (JSONException ex) {
            throw new QuandlRuntimeException("Cannot find field", ex);
        }
    }

    public Iterator<String> iterator() {
        return this._jsonObject.keys();
    }

    public JSONObject getRawJSON() {
        return this._jsonObject;
    }

    public String toString() {
        return this._jsonObject.toString();
    }

    public String toPrettyPrintedString() {
        return PrettyPrinter.toPrettyPrintedString(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetaDataResult)) {
            return false;
        }
        MetaDataResult other = (MetaDataResult)obj;
        return this.getRawJSON().toString().equals(other.getRawJSON().toString());
    }

    public int hashCode() {
        return this.getRawJSON().toString().hashCode();
    }
}

