/*
 * Decompiled with CFR 0.152.
 */
package com.jimmoores.quandl;

import com.jimmoores.quandl.util.ArgumentChecker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.client.WebTarget;

public final class MultiMetaDataRequest {
    private static final String COLUMNS_PARAM = "columns";
    private static final String EXTENSION = ".json";
    private static final String MULTI_SET_NAME = "multisets";
    private static final String EXCLUDE_DATA_PARAM = "trim_start";
    private static final String INFINITE_FUTURE = "2100-01-01";
    private List<String> _quandlCodes;

    private MultiMetaDataRequest(List<String> quandlCodes) {
        this._quandlCodes = Collections.unmodifiableList(new ArrayList<String>(quandlCodes));
    }

    public static MultiMetaDataRequest of(List<String> quandlCodes) {
        ArgumentChecker.notNullOrEmpty(quandlCodes, "quandlCodes");
        return new MultiMetaDataRequest(quandlCodes);
    }

    public static MultiMetaDataRequest of(String ... quandlCodes) {
        ArgumentChecker.notNullOrEmpty(quandlCodes, "quandlCodes");
        return new MultiMetaDataRequest(Arrays.asList(quandlCodes));
    }

    public List<String> getQuandlCodes() {
        return this._quandlCodes;
    }

    private String buildCodeList(List<String> quandlCodes) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = quandlCodes.iterator();
        while (iter.hasNext()) {
            String quandlCode = iter.next();
            if (quandlCode == null) {
                throw new IllegalArgumentException("There was a null encountered in the argument list " + quandlCodes);
            }
            String transformedCode = quandlCode.replace('/', '.');
            sb.append(transformedCode);
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public WebTarget appendPathAndQueryParameters(WebTarget webTarget) {
        ArgumentChecker.notNull(webTarget, "webTarget");
        WebTarget resultTarget = webTarget;
        resultTarget = resultTarget.path("multisets.json");
        resultTarget = resultTarget.queryParam(COLUMNS_PARAM, new Object[]{this.buildCodeList(this._quandlCodes)});
        resultTarget = resultTarget.queryParam(EXCLUDE_DATA_PARAM, new Object[]{INFINITE_FUTURE});
        return resultTarget;
    }

    public int hashCode() {
        return this._quandlCodes.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiMetaDataRequest)) {
            return false;
        }
        MultiMetaDataRequest other = (MultiMetaDataRequest)obj;
        return this._quandlCodes.equals(other._quandlCodes);
    }

    public String toString() {
        return "MultiMetaDataRequest[" + this._quandlCodes + "]";
    }
}

