/*
 * Decompiled with CFR 0.152.
 */
package com.jimmoores.quandl;

import com.jimmoores.quandl.util.ArgumentChecker;

public final class QuandlCodeRequest {
    private final String _quandlCode;
    private final Integer _columnNumber;

    private QuandlCodeRequest(String quandlCode, Integer columnNumber) {
        this._quandlCode = quandlCode;
        this._columnNumber = columnNumber;
    }

    public static QuandlCodeRequest singleColumn(String quandlCode, int columnNumber) {
        ArgumentChecker.notNull(quandlCode, "quandlCode");
        return new QuandlCodeRequest(quandlCode, columnNumber);
    }

    public static QuandlCodeRequest allColumns(String quandlCode) {
        ArgumentChecker.notNull(quandlCode, "quandlCode");
        return new QuandlCodeRequest(quandlCode, null);
    }

    public String getQuandlCode() {
        return this._quandlCode;
    }

    public Integer getColumnNumber() {
        return this._columnNumber;
    }

    public boolean isSingleColumnRequest() {
        return this._columnNumber != null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this._columnNumber != null) {
            result = 31 * result + this._columnNumber.hashCode();
        }
        result = 31 * result + this._quandlCode.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuandlCodeRequest)) {
            return false;
        }
        QuandlCodeRequest other = (QuandlCodeRequest)obj;
        if (!this._quandlCode.equals(other._quandlCode)) {
            return false;
        }
        return !(this._columnNumber == null ? other._columnNumber != null : !this._columnNumber.equals(other._columnNumber));
    }

    public String toString() {
        if (this.isSingleColumnRequest()) {
            return "QuandlCodeRequest[quandlCode=" + this._quandlCode + ", columnNumber=" + this._columnNumber + "]";
        }
        return "QuandlCodeRequest[quandlCode=" + this._quandlCode + ", all columns]";
    }
}

