/*
 * Decompiled with CFR 0.152.
 */
package com.jimmoores.quandl;

import com.jimmoores.quandl.DataSetRequest;
import com.jimmoores.quandl.HeaderDefinition;
import com.jimmoores.quandl.MetaDataRequest;
import com.jimmoores.quandl.MetaDataResult;
import com.jimmoores.quandl.MultiDataSetRequest;
import com.jimmoores.quandl.MultiMetaDataRequest;
import com.jimmoores.quandl.QuandlCodeRequest;
import com.jimmoores.quandl.Row;
import com.jimmoores.quandl.SearchRequest;
import com.jimmoores.quandl.SearchResult;
import com.jimmoores.quandl.SessionOptions;
import com.jimmoores.quandl.SortOrder;
import com.jimmoores.quandl.TabularResult;
import com.jimmoores.quandl.util.ArgumentChecker;
import com.jimmoores.quandl.util.QuandlRequestFailedException;
import com.jimmoores.quandl.util.QuandlRuntimeException;
import com.jimmoores.quandl.util.QuandlServiceUnavailableException;
import com.jimmoores.quandl.util.QuandlTooManyRequestsException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.UriBuilder;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.LocalDate;

public final class QuandlSession {
    private static final String JSON_TO_DATE_FIELD = "to_date";
    private static final String JSON_FROM_DATE_FIELD = "from_date";
    private static final String JSON_FREQUENCY_FIELD = "frequency";
    private static final String JSON_ERRORS_FIELD = "errors";
    private static final String JSON_DATA_FIELD = "data";
    private static final String JSON_COLUMNS_FIELD = "columns";
    private static final String JSON_COLUMN_NAMES_FIELD = "column_names";
    private static final String DATE_COLUMN = "Date";
    private static Logger s_logger = LoggerFactory.getLogger(QuandlSession.class);
    private SessionOptions _sessionOptions;
    private static final UriBuilder API_BASE_URL_V1 = UriBuilder.fromPath((String)"https://www.quandl.com/api/v1");
    private static final UriBuilder API_BASE_URL_V3 = UriBuilder.fromPath((String)"https://www.quandl.com/api/v3");
    private static final String QUANDL_AUTH_TOKEN_PROPERTY_NAME = "quandl.auth.token";
    public static final String AUTH_TOKEN_PARAM_NAME = "auth_token";

    private QuandlSession(SessionOptions sessionOptions) {
        this._sessionOptions = sessionOptions;
    }

    public static QuandlSession create(String authToken) {
        ArgumentChecker.notNull(authToken, "authToken");
        return new QuandlSession(SessionOptions.Builder.withAuthToken(authToken).build());
    }

    public static QuandlSession create() {
        try {
            String authToken = System.getProperty(QUANDL_AUTH_TOKEN_PROPERTY_NAME);
            if (authToken != null) {
                return new QuandlSession(SessionOptions.Builder.withAuthToken(authToken).build());
            }
        }
        catch (SecurityException se) {
            s_logger.debug("Error accessing system property quandl.auth.token, falling back to not using an auth token", (Throwable)se);
        }
        return new QuandlSession(SessionOptions.Builder.withoutAuthToken().build());
    }

    public static QuandlSession create(SessionOptions sessionOptions) {
        ArgumentChecker.notNull(sessionOptions, "sessionOptions");
        return new QuandlSession(sessionOptions);
    }

    protected Client getClient() {
        return ClientBuilder.newClient();
    }

    private WebTarget withAuthToken(WebTarget target) {
        if (this._sessionOptions.getAuthToken() != null) {
            return target.queryParam(AUTH_TOKEN_PARAM_NAME, new Object[]{this._sessionOptions.getAuthToken()});
        }
        return target;
    }

    public TabularResult getDataSet(DataSetRequest request) {
        ArgumentChecker.notNull(request, "request");
        Client client = this.getClient();
        WebTarget target = client.target(API_BASE_URL_V1);
        target = this.withAuthToken(target);
        target = request.appendPathAndQueryParameters(target);
        TabularResult tabularResponse = null;
        int retries = 0;
        do {
            try {
                tabularResponse = this._sessionOptions.getRESTDataProvider().getTabularResponse(target);
            }
            catch (QuandlTooManyRequestsException qtmre) {
                s_logger.debug("Quandl returned Too Many Requests, retrying if appropriate");
                if (!qtmre.isDataExhausted()) continue;
                throw new QuandlRequestFailedException("Data request limit exceeded", qtmre);
            }
            catch (QuandlServiceUnavailableException qsue) {
                s_logger.debug("Quandl returned Service Not Available, retrying if appropriate");
            }
        } while (tabularResponse == null && this._sessionOptions.getRetryPolicy().checkRetries(retries++));
        return tabularResponse;
    }

    public MetaDataResult getMetaData(MetaDataRequest request) {
        ArgumentChecker.notNull(request, "request");
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(API_BASE_URL_V1);
        target = this.withAuthToken(target);
        target = request.appendPathAndQueryParameters(target);
        JSONObject object = null;
        int retries = 0;
        do {
            try {
                object = this._sessionOptions.getRESTDataProvider().getJSONResponse(target);
            }
            catch (QuandlTooManyRequestsException qtmre) {
                s_logger.debug("Quandl returned Too Many Requests, retrying if appropriate");
                if (!qtmre.isDataExhausted()) continue;
                throw new QuandlRequestFailedException("Data request limit exceeded", qtmre);
            }
            catch (QuandlServiceUnavailableException qsue) {
                s_logger.debug("Quandl returned Service Not Available, retrying if appropriate");
            }
        } while (object == null && this._sessionOptions.getRetryPolicy().checkRetries(retries++));
        return MetaDataResult.of(object);
    }

    public TabularResult getDataSets(MultiDataSetRequest request) {
        List<QuandlCodeRequest> quandlCodeRequests = request.getQuandlCodeRequests();
        LinkedHashMap<QuandlCodeRequest, TabularResult> results = new LinkedHashMap<QuandlCodeRequest, TabularResult>();
        for (QuandlCodeRequest quandlCodeRequest : quandlCodeRequests) {
            DataSetRequest.Builder builder = DataSetRequest.Builder.of(quandlCodeRequest.getQuandlCode());
            if (quandlCodeRequest.isSingleColumnRequest()) {
                builder.withColumn(quandlCodeRequest.getColumnNumber());
            }
            if (request.getEndDate() != null) {
                builder.withEndDate(request.getEndDate());
            }
            if (request.getStartDate() != null) {
                builder.withStartDate(request.getStartDate());
            }
            if (request.getFrequency() != null) {
                builder.withFrequency(request.getFrequency());
            }
            if (request.getMaxRows() != null) {
                builder.withMaxRows(request.getMaxRows());
            }
            if (request.getSortOrder() != null) {
                builder.withSortOrder(request.getSortOrder());
            }
            if (request.getTransform() != null) {
                builder.withTransform(request.getTransform());
            }
            DataSetRequest dataSetRequest = builder.build();
            TabularResult tabularResult = null;
            try {
                tabularResult = this.getDataSet(dataSetRequest);
            }
            catch (QuandlRuntimeException qre) {
                s_logger.error("Exception processing request for {}, giving up and skipping.  Full request was {}", new Object[]{quandlCodeRequest.getQuandlCode(), dataSetRequest, qre});
                continue;
            }
            if (tabularResult != null) {
                results.put(quandlCodeRequest, tabularResult);
                continue;
            }
            s_logger.error("Can't process request for {}, returned null.  Giving up and skipping.  Full request was {}", (Object)quandlCodeRequest.getQuandlCode(), (Object)dataSetRequest);
        }
        return this.mergeTables(results, request.getSortOrder());
    }

    private TabularResult mergeTables(Map<QuandlCodeRequest, TabularResult> results, SortOrder sortOrder) {
        int resultTableWidth = 1;
        HashMap<Object, Integer> initialOffset = new HashMap<Object, Integer>();
        ArrayList<String> columnNames = new ArrayList<String>();
        columnNames.add(DATE_COLUMN);
        for (Map.Entry<QuandlCodeRequest, TabularResult> entry : results.entrySet()) {
            QuandlCodeRequest codeRequest = entry.getKey();
            TabularResult tabularResult = entry.getValue();
            if (!initialOffset.containsKey(codeRequest)) {
                initialOffset.put(codeRequest, resultTableWidth);
            }
            resultTableWidth += tabularResult.getHeaderDefinition().size() - 1;
            List<String> names = tabularResult.getHeaderDefinition().getColumnNames();
            Iterator<String> iter = names.iterator();
            if (!iter.hasNext()) {
                throw new QuandlRuntimeException("table has no columns, expected at least date");
            }
            iter.next();
            while (iter.hasNext()) {
                String colName = iter.next();
                columnNames.add(codeRequest.getQuandlCode() + " - " + colName);
            }
        }
        Comparator comparator = sortOrder == SortOrder.ASCENDING ? LocalDate.timeLineOrder() : Collections.reverseOrder(LocalDate.timeLineOrder());
        TreeMap rows = new TreeMap(comparator);
        for (Map.Entry entry : results.entrySet()) {
            QuandlCodeRequest codeRequest = (QuandlCodeRequest)entry.getKey();
            TabularResult table1 = (TabularResult)entry.getValue();
            for (Row row : table1) {
                String[] bigRow;
                LocalDate date = row.getLocalDate(0);
                String dateStr = row.getString(0);
                if (date == null) continue;
                if (rows.containsKey(date)) {
                    bigRow = (String[])rows.get(date);
                } else {
                    bigRow = new String[resultTableWidth];
                    rows.put(date, bigRow);
                }
                for (int i = 1; i < row.size(); ++i) {
                    bigRow[((Integer)initialOffset.get((Object)codeRequest)).intValue() + (i - 1)] = row.getString(i);
                }
                bigRow[0] = dateStr;
            }
        }
        ArrayList<Row> combinedRows = new ArrayList<Row>();
        HeaderDefinition headerDefinition = HeaderDefinition.of(columnNames);
        for (Map.Entry entry : rows.entrySet()) {
            Row row = Row.of(headerDefinition, (String[])entry.getValue());
            combinedRows.add(row);
        }
        return TabularResult.of(headerDefinition, combinedRows);
    }

    public MetaDataResult getMetaData(MultiMetaDataRequest request) {
        ArgumentChecker.notNull(request, "request");
        Map<String, HeaderDefinition> multipleHeaderDefinition = this.getMultipleHeaderDefinition(request);
        try {
            JSONObject result = new JSONObject();
            if (multipleHeaderDefinition.size() > 0) {
                result.append(JSON_COLUMN_NAMES_FIELD, (Object)DATE_COLUMN);
                result.append(JSON_COLUMNS_FIELD, (Object)DATE_COLUMN);
            }
            for (Map.Entry<String, HeaderDefinition> entry : multipleHeaderDefinition.entrySet()) {
                String quandlCode = entry.getKey();
                HeaderDefinition headerDef = entry.getValue();
                for (String columnName : headerDef.getColumnNames()) {
                    if (columnName.equals(DATE_COLUMN)) continue;
                    result.append(JSON_COLUMN_NAMES_FIELD, (Object)(quandlCode + " - " + columnName));
                    result.append(JSON_COLUMNS_FIELD, (Object)columnName);
                }
            }
            result.put(JSON_DATA_FIELD, (Object)new JSONArray());
            result.put(JSON_ERRORS_FIELD, Collections.emptyMap());
            result.put(JSON_FREQUENCY_FIELD, null);
            result.put(JSON_FROM_DATE_FIELD, null);
            result.put(JSON_TO_DATE_FIELD, null);
            return MetaDataResult.of(result);
        }
        catch (JSONException ex) {
            throw new QuandlRuntimeException("Problem building JSON response", ex);
        }
    }

    public Map<String, HeaderDefinition> getMultipleHeaderDefinition(MultiMetaDataRequest request) {
        LinkedHashMap<String, HeaderDefinition> bulkMetaData = new LinkedHashMap<String, HeaderDefinition>();
        for (String quandlCode : request.getQuandlCodes()) {
            try {
                MetaDataResult metaData = this.getMetaData(MetaDataRequest.of(quandlCode));
                bulkMetaData.put(quandlCode, metaData.getHeaderDefinition());
            }
            catch (QuandlRuntimeException qre) {
                s_logger.error("There was a problem requesting metadata for {}, skipping", (Object)quandlCode, (Object)qre);
            }
        }
        return bulkMetaData;
    }

    public SearchResult search(SearchRequest request) {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(API_BASE_URL_V3);
        target = this.withAuthToken(target);
        target = request.appendPathAndQueryParameters(target);
        int retries = 0;
        JSONObject jsonResponse = null;
        do {
            try {
                jsonResponse = this._sessionOptions.getRESTDataProvider().getJSONResponse(target);
            }
            catch (QuandlTooManyRequestsException qtmre) {
                s_logger.debug("Quandl returned Too Many Requests, retrying if appropriate");
                if (!qtmre.isDataExhausted()) continue;
                throw new QuandlRequestFailedException("Data request limit exceeded", qtmre);
            }
            catch (QuandlServiceUnavailableException qsue) {
                s_logger.debug("Quandl returned Service Not Available, retrying if appropriate");
            }
        } while (jsonResponse == null && this._sessionOptions.getRetryPolicy().checkRetries(retries++));
        SearchResult searchResult = SearchResult.of(jsonResponse);
        return searchResult;
    }
}

