/*
 * Decompiled with CFR 0.152.
 */
package com.jimmoores.quandl;

import com.jimmoores.quandl.util.QuandlRequestFailedException;
import com.jimmoores.quandl.util.QuandlRuntimeException;

public abstract class RetryPolicy {
    public abstract boolean checkRetries(int var1);

    public static RetryPolicy createNoRetryPolicy() {
        return new NoRetryPolicy();
    }

    public static RetryPolicy createFixedRetryPolicy(int maxRetries, long backOffPeriod) {
        return new FixedRetryPolicy(maxRetries, backOffPeriod);
    }

    public static RetryPolicy createSequenceRetryPolicy(long[] backOffPeriods) {
        return new SequenceRetryPolicy(backOffPeriods);
    }

    private static final class SequenceRetryPolicy
    extends RetryPolicy {
        private int _maxRetries;
        private long[] _backOffPeriods;

        private SequenceRetryPolicy(long[] backOffPeriods) {
            this._maxRetries = backOffPeriods.length;
            this._backOffPeriods = backOffPeriods;
        }

        @Override
        public boolean checkRetries(int retries) {
            if (retries < this._maxRetries && retries >= 0) {
                try {
                    Thread.sleep(this._backOffPeriods[retries]);
                }
                catch (InterruptedException ie) {
                    throw new QuandlRequestFailedException("Giving up on request, received InterruptedException", ie);
                }
            } else {
                throw new QuandlRequestFailedException("Giving up on request after " + this._maxRetries);
            }
            return true;
        }
    }

    private static final class FixedRetryPolicy
    extends RetryPolicy {
        private int _maxRetries;
        private long _backOffPeriod;

        private FixedRetryPolicy(int maxRetries, long backOffPeriod) {
            this._maxRetries = maxRetries;
            this._backOffPeriod = backOffPeriod;
        }

        @Override
        public boolean checkRetries(int retries) {
            if (retries < this._maxRetries && retries >= 0) {
                try {
                    Thread.sleep(this._backOffPeriod);
                }
                catch (InterruptedException ie) {
                    throw new QuandlRequestFailedException("Giving up on request, received InterruptedException", ie);
                }
            } else {
                throw new QuandlRequestFailedException("Giving up on request after " + this._maxRetries + " retries of " + this._backOffPeriod + "ms each.");
            }
            return true;
        }
    }

    private static final class NoRetryPolicy
    extends RetryPolicy {
        private NoRetryPolicy() {
        }

        @Override
        public boolean checkRetries(int retries) {
            throw new QuandlRuntimeException("Request failed, policy is no retry.");
        }
    }
}

