/*
 * Decompiled with CFR 0.152.
 */
package com.jimmoores.quandl;

import com.jimmoores.quandl.HeaderDefinition;
import com.jimmoores.quandl.util.ArgumentChecker;
import com.jimmoores.quandl.util.QuandlRuntimeException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.LocalDate;
import org.threeten.bp.format.DateTimeFormatter;

public final class Row {
    private static Logger s_logger = LoggerFactory.getLogger(Row.class);
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE;
    private final HeaderDefinition _headerDefinition;
    private final String[] _values;

    private Row(HeaderDefinition headerDefinition, String[] values) {
        if (headerDefinition.size() != values.length) {
            s_logger.error("Attempt to create a Row with a header definition containing {} columns and a values array containing {} values", (Object)headerDefinition.size(), (Object)values.length);
            throw new QuandlRuntimeException("headerDefinition and values array are of differing length");
        }
        this._headerDefinition = headerDefinition;
        this._values = values;
    }

    public static Row of(HeaderDefinition headerDefinition, String[] values) {
        ArgumentChecker.notNull(headerDefinition, "headerDefinition");
        ArgumentChecker.notNull(values, "values");
        return new Row(headerDefinition, values);
    }

    public String getString(int index) {
        return this._values[index];
    }

    public String getString(String column) {
        return this._values[this._headerDefinition.columnIndex(column)];
    }

    public LocalDate getLocalDate(int index) {
        if (this._values[index] == null || this._values[index].isEmpty()) {
            return null;
        }
        return LocalDate.parse((CharSequence)this._values[index], (DateTimeFormatter)DATE_FORMATTER);
    }

    public LocalDate getLocalDate(String column) {
        int index = this._headerDefinition.columnIndex(column);
        return this.getLocalDate(index);
    }

    public Double getDouble(int index) {
        if (this._values[index] == null || this._values[index].isEmpty()) {
            return null;
        }
        return Double.parseDouble(this._values[index]);
    }

    public Double getDouble(String column) {
        int index = this._headerDefinition.columnIndex(column);
        return this.getDouble(index);
    }

    public int size() {
        return this._values.length;
    }

    public Row withPaddedHeader(HeaderDefinition headerDefinition) {
        if (this._headerDefinition != headerDefinition) {
            String[] values = new String[headerDefinition.size()];
            System.arraycopy(this._values, 0, values, 0, this._values.length);
            return Row.of(headerDefinition, values);
        }
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._headerDefinition.hashCode();
        result = 31 * result + Arrays.hashCode(this._values);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Row)) {
            return false;
        }
        Row other = (Row)obj;
        if (!this._headerDefinition.equals(other._headerDefinition)) {
            return false;
        }
        return Arrays.equals(this._values, other._values);
    }

    public String toString() {
        return "Row[headerDefinition=" + this._headerDefinition + ", values=" + Arrays.toString(this._values) + "]";
    }
}

