/*
 * Decompiled with CFR 0.152.
 */
package com.jimmoores.quandl;

import com.jimmoores.quandl.util.ArgumentChecker;
import javax.ws.rs.client.WebTarget;

public final class SearchRequest {
    private static final String EXTENSION = ".json";
    private static final String DATASETS_RELATIVE_URL = "datasets";
    private static final String DATABASE_CODE_PARAM = "database_code";
    private static final String QUERY_PARAM = "query";
    private static final String PAGE_PARAM = "page";
    private static final String PER_PAGE_PARAM = "per_page";
    private final String _databaseCode;
    private final String _query;
    private Integer _pageNumber;
    private Integer _maxDocsPerPage;

    private SearchRequest(Builder builder) {
        this._databaseCode = builder._databaseCode;
        this._query = builder._query;
        this._pageNumber = builder._pageNumber;
        this._maxDocsPerPage = builder._maxDocsPerPage;
    }

    public String getDatabaseCode() {
        return this._databaseCode;
    }

    public String getQuery() {
        return this._query;
    }

    public Integer getPageNumber() {
        return this._pageNumber;
    }

    public Integer getMaxPerPage() {
        return this._maxDocsPerPage;
    }

    public WebTarget appendPathAndQueryParameters(WebTarget webTarget) {
        ArgumentChecker.notNull(webTarget, "webTarget");
        WebTarget resultTarget = webTarget;
        resultTarget = resultTarget.path("datasets.json");
        if (this._databaseCode != null) {
            resultTarget = resultTarget.queryParam(DATABASE_CODE_PARAM, new Object[]{this._databaseCode});
        }
        if (this._query != null) {
            resultTarget = resultTarget.queryParam(QUERY_PARAM, new Object[]{this._query});
        }
        if (this._pageNumber != null) {
            resultTarget = resultTarget.queryParam(PAGE_PARAM, new Object[]{this._pageNumber});
        }
        if (this._maxDocsPerPage != null) {
            resultTarget = resultTarget.queryParam(PER_PAGE_PARAM, new Object[]{this._maxDocsPerPage});
        }
        return resultTarget;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this._maxDocsPerPage != null) {
            result = 31 * result + this._maxDocsPerPage;
        }
        if (this._pageNumber != null) {
            result = 31 * result + this._pageNumber;
        }
        if (this._query != null) {
            result = 31 * result + this._query.hashCode();
        }
        if (this._databaseCode != null) {
            result = 31 * result + this._databaseCode.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchRequest)) {
            return false;
        }
        SearchRequest other = (SearchRequest)obj;
        if (!this._databaseCode.equals(other._databaseCode)) {
            return false;
        }
        if (!this._query.equals(other._query)) {
            return false;
        }
        if (!this._maxDocsPerPage.equals(other._maxDocsPerPage)) {
            return false;
        }
        return this._pageNumber.equals(other._pageNumber);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SearchRequest[");
        if (this._databaseCode != null) {
            builder.append("databaseCode=");
            builder.append(this._databaseCode);
        }
        if (this._query != null) {
            if (builder.charAt(builder.length() - 1) != '[') {
                builder.append(", ");
            }
            builder.append("query=");
            builder.append(this._query);
        }
        if (this._pageNumber != null) {
            if (builder.charAt(builder.length() - 1) != '[') {
                builder.append(", ");
            }
            builder.append("pageNumber=");
            builder.append(this._pageNumber);
        }
        if (this._maxDocsPerPage != null) {
            if (builder.charAt(builder.length() - 1) != '[') {
                builder.append(", ");
            }
            builder.append("maxDocsPerPage=");
            builder.append(this._maxDocsPerPage);
        }
        builder.append("]");
        return builder.toString();
    }

    public static final class Builder {
        private String _databaseCode;
        private String _query;
        private Integer _pageNumber;
        private Integer _maxDocsPerPage;

        public Builder() {
        }

        @Deprecated
        private Builder(String query) {
            this._query = query;
        }

        @Deprecated
        public static Builder of(String query) {
            ArgumentChecker.notNull(query, SearchRequest.QUERY_PARAM);
            return new Builder(query);
        }

        public Builder withDatabaseCode(String databaseCode) {
            this._databaseCode = databaseCode;
            return this;
        }

        public Builder withQuery(String query) {
            this._query = query;
            return this;
        }

        public Builder withPageNumber(int pageNumber) {
            this._pageNumber = pageNumber;
            return this;
        }

        public Builder withMaxPerPage(int maxDocsPerPage) {
            this._maxDocsPerPage = maxDocsPerPage;
            return this;
        }

        public SearchRequest build() {
            return new SearchRequest(this);
        }
    }
}

