/*
 * Decompiled with CFR 0.152.
 */
package com.jimmoores.quandl;

import com.jimmoores.quandl.MetaDataResult;
import com.jimmoores.quandl.util.ArgumentChecker;
import com.jimmoores.quandl.util.PrettyPrinter;
import com.jimmoores.quandl.util.QuandlRuntimeException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SearchResult {
    private static Logger s_logger = LoggerFactory.getLogger(SearchResult.class);
    private static final String META_OBJECT_FIELD = "meta";
    private static final String DATASETS_ARRAY_FIELD = "datasets";
    private JSONObject _jsonObject;

    private SearchResult(JSONObject jsonObject) {
        this._jsonObject = jsonObject;
    }

    public static SearchResult of(JSONObject jsonObject) {
        ArgumentChecker.notNull(jsonObject, "jsonObject");
        return new SearchResult(jsonObject);
    }

    public int getTotalDocuments() {
        try {
            int totalDocs = this._jsonObject.getJSONObject(META_OBJECT_FIELD).getInt("total_count");
            return totalDocs;
        }
        catch (JSONException ex) {
            throw new QuandlRuntimeException("Could not find total_count field in results from Quandl", ex);
        }
    }

    public int getDocumentsPerPage() {
        try {
            int perPage = this._jsonObject.getJSONObject(META_OBJECT_FIELD).getInt("per_page");
            return perPage;
        }
        catch (JSONException ex) {
            throw new QuandlRuntimeException("Could not find total_count field in results from Quandl", ex);
        }
    }

    public int getCurrentPage() {
        try {
            int currentPage = this._jsonObject.getJSONObject(META_OBJECT_FIELD).getInt("current_page");
            return currentPage;
        }
        catch (JSONException ex) {
            throw new QuandlRuntimeException("Could not find total_count field in results from Quandl", ex);
        }
    }

    public List<MetaDataResult> getMetaDataResultList() {
        JSONArray jsonArray = null;
        try {
            jsonArray = this._jsonObject.getJSONArray(DATASETS_ARRAY_FIELD);
            ArrayList<MetaDataResult> metaDataResults = new ArrayList<MetaDataResult>(jsonArray.length());
            for (int i = 0; i < jsonArray.length(); ++i) {
                metaDataResults.add(MetaDataResult.of(jsonArray.getJSONObject(i)));
            }
            return metaDataResults;
        }
        catch (JSONException ex) {
            s_logger.error("Metadata had unexpected structure - could not extract datasets field, was:\n{}", (Object)this._jsonObject.toString());
            throw new QuandlRuntimeException("Metadata had unexpected structure", ex);
        }
    }

    public Iterator<MetaDataResult> iterator() {
        return this.getMetaDataResultList().iterator();
    }

    public JSONObject getRawJSON() {
        return this._jsonObject;
    }

    public String toString() {
        return this._jsonObject.toString();
    }

    public String toPrettyPrintedString() {
        return PrettyPrinter.toPrettyPrintedString(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchResult)) {
            return false;
        }
        SearchResult other = (SearchResult)obj;
        return this.getRawJSON().toString().equals(other.getRawJSON().toString());
    }

    public int hashCode() {
        return this.getRawJSON().toString().hashCode();
    }
}

