/*
 * Decompiled with CFR 0.152.
 */
package com.jimmoores.quandl;

import com.jimmoores.quandl.RetryPolicy;
import com.jimmoores.quandl.util.ArgumentChecker;
import com.jimmoores.quandl.util.DefaultRESTDataProvider;
import com.jimmoores.quandl.util.RESTDataProvider;

public final class SessionOptions {
    private String _authToken;
    private RESTDataProvider _restDataProvider;
    private RetryPolicy _retryPolicy;

    private SessionOptions(Builder builder) {
        this._authToken = builder._authToken;
        this._restDataProvider = builder._restDataProvider;
        this._retryPolicy = builder._retryPolicy;
    }

    public String getAuthToken() {
        return this._authToken;
    }

    public RESTDataProvider getRESTDataProvider() {
        return this._restDataProvider;
    }

    public RetryPolicy getRetryPolicy() {
        return this._retryPolicy;
    }

    public static final class Builder {
        private static final long ONE_SECOND = 1000L;
        private static final long FIVE_SECONDS = 5000L;
        private static final long TWENTY_SECONDS = 20000L;
        private static final long SIXTY_SECONDS = 60000L;
        private String _authToken;
        private RESTDataProvider _restDataProvider = new DefaultRESTDataProvider();
        private RetryPolicy _retryPolicy = RetryPolicy.createSequenceRetryPolicy(new long[]{1000L, 5000L, 20000L, 60000L});

        private Builder(String authToken) {
            this._authToken = authToken;
        }

        public static Builder withAuthToken(String authToken) {
            ArgumentChecker.notNull(authToken, "authToken");
            return new Builder(authToken);
        }

        public static Builder withoutAuthToken() {
            return new Builder(null);
        }

        public Builder withRESTDataProvider(RESTDataProvider restDataProvider) {
            ArgumentChecker.notNull(restDataProvider, "restDataProvider");
            this._restDataProvider = restDataProvider;
            return this;
        }

        public Builder withRetryPolicy(RetryPolicy retryPolicy) {
            ArgumentChecker.notNull(retryPolicy, "retryPolicy");
            this._retryPolicy = retryPolicy;
            return this;
        }

        public SessionOptions build() {
            return new SessionOptions(this);
        }
    }
}

