/*
 * Decompiled with CFR 0.152.
 */
package com.jimmoores.quandl;

import com.jimmoores.quandl.HeaderDefinition;
import com.jimmoores.quandl.Row;
import com.jimmoores.quandl.util.ArgumentChecker;
import com.jimmoores.quandl.util.PrettyPrinter;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class TabularResult
implements Iterable<Row> {
    private HeaderDefinition _headerDefinition;
    private List<Row> _rows;

    private TabularResult(HeaderDefinition headerDefinition, List<Row> rows) {
        this._headerDefinition = headerDefinition;
        this._rows = Collections.unmodifiableList(rows);
    }

    public static TabularResult of(HeaderDefinition headerDefinition, List<Row> rows) {
        ArgumentChecker.notNull(headerDefinition, "headerDefinition");
        ArgumentChecker.notNull(rows, "rows");
        return new TabularResult(headerDefinition, rows);
    }

    public HeaderDefinition getHeaderDefinition() {
        return this._headerDefinition;
    }

    public Row get(int index) {
        return this._rows.get(index);
    }

    public int size() {
        return this._rows.size();
    }

    public boolean isEmpty() {
        return this._rows.isEmpty();
    }

    @Override
    public Iterator<Row> iterator() {
        return this._rows.iterator();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._headerDefinition.hashCode();
        result = 31 * result + this._rows.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TabularResult)) {
            return false;
        }
        TabularResult other = (TabularResult)obj;
        if (!this._headerDefinition.equals(other._headerDefinition)) {
            return false;
        }
        return this._rows.equals(other._rows);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TabularResult[headerDefinition=");
        builder.append(this._headerDefinition);
        builder.append(", rows=");
        builder.append(this._rows);
        builder.append("]");
        return builder.toString();
    }

    public String toPrettyPrintedString() {
        return PrettyPrinter.toPrettyPrintedString(this);
    }
}

