/*
 * Decompiled with CFR 0.152.
 */
package com.jimmoores.quandl.example;

import com.jimmoores.quandl.Frequency;
import com.jimmoores.quandl.MultiDataSetRequest;
import com.jimmoores.quandl.QuandlCodeRequest;
import com.jimmoores.quandl.QuandlSession;
import com.jimmoores.quandl.Row;
import com.jimmoores.quandl.TabularResult;
import org.threeten.bp.LocalDate;

public final class Example3a {
    private static final int CLOSE_COLUMN = 4;
    private static final LocalDate RECENTISH_DATE = LocalDate.of((int)2013, (int)1, (int)1);

    private Example3a() {
    }

    private void run() {
        QuandlSession session = QuandlSession.create();
        TabularResult tabularResultMulti = session.getDataSets(MultiDataSetRequest.Builder.of(QuandlCodeRequest.singleColumn("WIKI/AAPL", 4), QuandlCodeRequest.allColumns("DOE/RWTC")).withStartDate(RECENTISH_DATE).withFrequency(Frequency.MONTHLY).build());
        System.out.println("Header definition: " + tabularResultMulti.getHeaderDefinition());
        for (Row row : tabularResultMulti) {
            LocalDate date = row.getLocalDate("Date");
            Double value = row.getDouble("DOE/RWTC - Value");
            System.out.println("Value on date " + date + " was " + value);
        }
    }

    public static void main(String[] args) {
        Example3a example = new Example3a();
        example.run();
    }
}

