/*
 * Decompiled with CFR 0.152.
 */
package com.jimmoores.quandl.example;

import com.jimmoores.quandl.MetaDataResult;
import com.jimmoores.quandl.QuandlSession;
import com.jimmoores.quandl.SearchRequest;
import com.jimmoores.quandl.SearchResult;

public final class Example8 {
    private Example8() {
    }

    private void run() {
        QuandlSession session = QuandlSession.create();
        SearchResult searchResult = session.search(new SearchRequest.Builder().withQuery("Apple").withMaxPerPage(2).build());
        System.out.println("Current page:" + searchResult.getCurrentPage());
        System.out.println("Documents per page:" + searchResult.getDocumentsPerPage());
        System.out.println("Total matching documents:" + searchResult.getTotalDocuments());
        for (MetaDataResult document : searchResult.getMetaDataResultList()) {
            System.out.println("Quandl code " + document.getQuandlCode() + " matched");
            System.out.println("Available columns are: " + document.getHeaderDefinition());
        }
    }

    public static void main(String[] args) {
        Example8 example = new Example8();
        example.run();
    }
}

