/*
 * Decompiled with CFR 0.152.
 */
package com.jimmoores.quandl.util;

import com.jimmoores.quandl.util.QuandlRuntimeException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArgumentChecker {
    private static Logger s_logger = LoggerFactory.getLogger(ArgumentChecker.class);

    private ArgumentChecker() {
    }

    public static void notNull(Object argument, String name) {
        if (argument == null) {
            s_logger.error("Argument {} was null", (Object)name);
            throw new QuandlRuntimeException("Value " + name + " was null");
        }
    }

    public static <E> void notNullOrEmpty(E[] argument, String name) {
        if (argument == null) {
            s_logger.error("Argument {} was null", (Object)name);
            throw new QuandlRuntimeException("Value " + name + " was null");
        }
        if (argument.length == 0) {
            s_logger.error("Argument {} was empty array", (Object)name);
            throw new QuandlRuntimeException("Value " + name + " was empty array");
        }
    }

    public static <E> void notNullOrEmpty(Collection<E> argument, String name) {
        if (argument == null) {
            s_logger.error("Argument {} was null", (Object)name);
            throw new QuandlRuntimeException("Value " + name + " was null");
        }
        if (argument.size() == 0) {
            s_logger.error("Argument {} was empty collection", (Object)name);
            throw new QuandlRuntimeException("Value " + name + " was empty collection");
        }
    }

    public static void notNullOrEmpty(String argument, String name) {
        if (argument == null) {
            s_logger.error("Argument {} was null", (Object)name);
            throw new QuandlRuntimeException("Value " + name + " was null");
        }
        if (argument.length() == 0) {
            s_logger.error("Argument {} was empty string", (Object)name);
            throw new QuandlRuntimeException("Value " + name + " was empty string");
        }
    }
}

