/*
 * Decompiled with CFR 0.152.
 */
package com.jimmoores.quandl.util;

import au.com.bytecode.opencsv.CSVReader;
import com.jimmoores.quandl.HeaderDefinition;
import com.jimmoores.quandl.Row;
import com.jimmoores.quandl.TabularResult;
import com.jimmoores.quandl.util.QuandlRuntimeException;
import com.jimmoores.quandl.util.QuandlServiceUnavailableException;
import com.jimmoores.quandl.util.QuandlTooManyRequestsException;
import com.jimmoores.quandl.util.QuandlUnprocessableEntityException;
import com.jimmoores.quandl.util.RESTDataProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public final class DefaultRESTDataProvider
implements RESTDataProvider {
    private static final String RETRY_AFTER = "Retry-After";
    private static final String X_RATELIMIT_LIMIT = "X-RateLimit-Limit";
    private static final String X_RATELIMIT_REMAINING = "X-RateLimit-Remaining";

    @Override
    public JSONObject getJSONResponse(WebTarget target) {
        Invocation.Builder requestBuilder = target.request();
        Response response = requestBuilder.buildGet().invoke();
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            InputStream inputStream = (InputStream)response.readEntity(InputStream.class);
            JSONTokener tokeniser = new JSONTokener((Reader)new InputStreamReader(inputStream));
            try {
                JSONObject object = new JSONObject(tokeniser);
                return object;
            }
            catch (JSONException jsone) {
                throw new QuandlRuntimeException("Problem parsing JSON reply", jsone);
            }
        }
        if (response.getStatus() == 422) {
            throw new QuandlUnprocessableEntityException("Response code to " + target.getUri() + " was " + response.getStatusInfo());
        }
        if (response.getStatus() == 429) {
            Long retryAfter = this.parseOptionalHeader(response, RETRY_AFTER);
            Long rateLimitLimit = this.parseOptionalHeader(response, X_RATELIMIT_LIMIT);
            Long rateLimitRemaining = this.parseOptionalHeader(response, X_RATELIMIT_REMAINING);
            throw new QuandlTooManyRequestsException("Response code to " + target.getUri() + " was " + response.getStatusInfo(), retryAfter, rateLimitLimit, rateLimitRemaining);
        }
        if (response.getStatus() == 503) {
            throw new QuandlServiceUnavailableException("Response code to " + target.getUri() + " was 503 (Service Unavailable)");
        }
        throw new QuandlRuntimeException("Response code to " + target.getUri() + " was " + response.getStatusInfo());
    }

    private Long parseOptionalHeader(Response response, String field) {
        String value = response.getHeaderString(field);
        if (value != null) {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public TabularResult getTabularResponse(WebTarget target) {
        Invocation.Builder requestBuilder = target.request();
        Response response = requestBuilder.buildGet().invoke();
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            InputStream inputStream = (InputStream)response.readEntity(InputStream.class);
            CSVReader reader = new CSVReader((Reader)new InputStreamReader(inputStream));
            try {
                String[] headerRow = reader.readNext();
                if (headerRow != null) {
                    HeaderDefinition headerDef = HeaderDefinition.of(Arrays.asList(headerRow));
                    ArrayList<Row> rows = new ArrayList<Row>();
                    String[] next = reader.readNext();
                    int maxWidth = headerRow.length;
                    while (next != null) {
                        if (next.length > headerRow.length) {
                            String[] stretchedHeaderRow = new String[next.length];
                            System.arraycopy(headerRow, 0, stretchedHeaderRow, 0, headerRow.length);
                            for (int i = headerRow.length; i < next.length; ++i) {
                                stretchedHeaderRow[i] = "Column " + i;
                            }
                            headerRow = stretchedHeaderRow;
                            headerDef = HeaderDefinition.of(Arrays.asList(headerRow));
                        }
                        Row row = Row.of(headerDef, next);
                        rows.add(row);
                        next = reader.readNext();
                    }
                    reader.close();
                    return TabularResult.of(headerDef, rows);
                }
                reader.close();
                throw new QuandlRuntimeException("No data returned");
            }
            catch (IOException ex) {
                throw new QuandlRuntimeException("Problem reading result stream", ex);
            }
        }
        if (response.getStatus() == 422) {
            throw new QuandlUnprocessableEntityException("Response code to " + target.getUri() + " was " + response.getStatusInfo());
        }
        if (response.getStatus() == 429) {
            Long retryAfter = this.parseOptionalHeader(response, RETRY_AFTER);
            Long rateLimitLimit = this.parseOptionalHeader(response, X_RATELIMIT_LIMIT);
            Long rateLimitRemaining = this.parseOptionalHeader(response, X_RATELIMIT_REMAINING);
            throw new QuandlTooManyRequestsException("Response code to " + target.getUri() + " was " + response.getStatusInfo(), retryAfter, rateLimitLimit, rateLimitRemaining);
        }
        if (response.getStatus() == 503) {
            throw new QuandlServiceUnavailableException("Response code to " + target.getUri() + " was 503 (Service Unavailable)");
        }
        throw new QuandlRuntimeException("Response code to " + target.getUri() + " was " + response.getStatusInfo());
    }
}

