/*
 * Decompiled with CFR 0.152.
 */
package com.jimmoores.quandl.util;

import com.jimmoores.quandl.HeaderDefinition;
import com.jimmoores.quandl.MetaDataResult;
import com.jimmoores.quandl.Row;
import com.jimmoores.quandl.SearchResult;
import com.jimmoores.quandl.TabularResult;
import com.jimmoores.quandl.util.ArgumentChecker;
import com.jimmoores.quandl.util.QuandlRuntimeException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PrettyPrinter {
    private static Logger s_logger = LoggerFactory.getLogger(PrettyPrinter.class);
    private static final String NULL = "null";
    private static final int NULL_SIZE = "null".length();
    private static final int JSON_INDENT = 2;
    private static final String LINE_SEPARATOR = "\n";

    private PrettyPrinter() {
    }

    public static String toPrettyPrintedString(SearchResult searchResult) {
        return PrettyPrinter.toPrettyPrintedString(searchResult.getRawJSON());
    }

    public static String toPrettyPrintedString(MetaDataResult metaDataResult) {
        return PrettyPrinter.toPrettyPrintedString(metaDataResult.getRawJSON());
    }

    public static String toPrettyPrintedString(JSONObject jsonObject) {
        ArgumentChecker.notNull(jsonObject, "jsonObject");
        try {
            return jsonObject.toString(2) + LINE_SEPARATOR;
        }
        catch (JSONException ex) {
            s_logger.error("Problem converting JSONObject to String", (Throwable)ex);
            throw new QuandlRuntimeException("Problem converting JSONObject to String", ex);
        }
    }

    public static String toPrettyPrintedString(Map<String, HeaderDefinition> multiHeaderDefinitionResult) {
        ArgumentChecker.notNull(multiHeaderDefinitionResult, "multiHeaderDefinitionResult");
        StringBuilder sb = new StringBuilder();
        int max = 0;
        for (String string : multiHeaderDefinitionResult.keySet()) {
            max = Math.max(max, string.length());
        }
        for (Map.Entry entry : multiHeaderDefinitionResult.entrySet()) {
            String quandlCode = (String)entry.getKey();
            HeaderDefinition headerDefinition = (HeaderDefinition)entry.getValue();
            sb.append(quandlCode);
            sb.append(PrettyPrinter.repeat(max - quandlCode.length(), ' '));
            sb.append(" => ");
            Iterator<String> iterator = headerDefinition.iterator();
            while (iterator.hasNext()) {
                sb.append(iterator.next());
                if (!iterator.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(LINE_SEPARATOR);
        }
        return sb.toString();
    }

    public static String toPrettyPrintedString(TabularResult result) {
        ArgumentChecker.notNull(result, "result");
        StringBuilder sb = new StringBuilder();
        int[] maxWidths = PrettyPrinter.maximumWidths(result);
        PrettyPrinter.separator(sb, maxWidths);
        PrettyPrinter.header(sb, maxWidths, result.getHeaderDefinition());
        PrettyPrinter.separator(sb, maxWidths);
        for (Row row : result) {
            PrettyPrinter.row(sb, maxWidths, row);
        }
        PrettyPrinter.separator(sb, maxWidths);
        return sb.toString();
    }

    private static void separator(StringBuilder sb, int[] maxWidths) {
        for (int width : maxWidths) {
            sb.append("+");
            sb.append(PrettyPrinter.repeat(width + 2, '-'));
        }
        sb.append("+");
        sb.append(LINE_SEPARATOR);
    }

    private static void row(StringBuilder sb, int[] maxWidths, Row row) {
        int i = 0;
        for (int width : maxWidths) {
            String value = row.getString(i++);
            sb.append("| ");
            if (value != null) {
                sb.append(value);
                sb.append(PrettyPrinter.repeat(width - value.length(), ' '));
            } else {
                sb.append(NULL);
                sb.append(PrettyPrinter.repeat(width - NULL_SIZE, ' '));
            }
            sb.append(" ");
        }
        sb.append("|");
        sb.append(LINE_SEPARATOR);
    }

    private static void header(StringBuilder sb, int[] maxWidths, HeaderDefinition headerDefinition) {
        Iterator<String> iterator = headerDefinition.iterator();
        for (int width : maxWidths) {
            String value = iterator.next();
            sb.append("| ");
            if (value != null) {
                sb.append(value);
                sb.append(PrettyPrinter.repeat(width - value.length(), ' '));
            } else {
                sb.append(NULL);
                sb.append(PrettyPrinter.repeat(width - NULL_SIZE, ' '));
            }
            sb.append(" ");
        }
        sb.append("|");
        sb.append(LINE_SEPARATOR);
    }

    private static String repeat(int n, char v) {
        char[] repeated = new char[n];
        Arrays.fill(repeated, v);
        return new String(repeated);
    }

    private static int[] maximumWidths(TabularResult result) {
        HeaderDefinition headerDefinition = result.getHeaderDefinition();
        int[] maxWidths = new int[headerDefinition.size()];
        int count = 0;
        for (String columnName : headerDefinition.getColumnNames()) {
            maxWidths[count++] = columnName.length();
        }
        for (Row row : result) {
            for (int i = 0; i < row.size(); ++i) {
                String columnValue = row.getString(i);
                maxWidths[i] = columnValue != null ? Math.max(maxWidths[i], columnValue.length()) : Math.max(maxWidths[i], NULL_SIZE);
            }
        }
        return maxWidths;
    }
}

