/*
 * Decompiled with CFR 0.152.
 */
package com.jjmoo.appjoint;

import android.app.Application;
import android.content.Context;
import androidx.annotation.CheckResult;
import androidx.annotation.Nullable;
import com.jjmoo.appjoint.AppLike;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class AppJoint {
    private static Map<Class, Class> sImplClassMap = new HashMap<Class, Class>();
    private static Map<Class, Object> sInstanceMap = new HashMap<Class, Object>();

    @Nullable
    @CheckResult
    public static synchronized <T> T service(Class<T> clazz) {
        Class impl;
        Object result = sInstanceMap.get(clazz);
        if (null == result && null != (impl = sImplClassMap.get(clazz))) {
            try {
                Constructor<?>[] constructors;
                for (Constructor<?> constructor : constructors = impl.getConstructors()) {
                    Class<?>[] params = constructor.getParameterTypes();
                    if (0 == params.length) {
                        result = impl.newInstance();
                        continue;
                    }
                    if (1 != params.length || Context.class != params[0] && Application.class != params[0]) continue;
                    result = constructor.newInstance(AppLike.getInstance().getContext());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (null == result) {
                throw new RuntimeException("no available constructor found !");
            }
            sInstanceMap.put(clazz, result);
        }
        return (T)result;
    }

    private static synchronized <T> void register(Class<T> clazz, Class<? extends T> implClazz) {
        sImplClassMap.put(clazz, implClazz);
    }
}

