/*
 * Decompiled with CFR 0.152.
 */
package com.jjmoo.appjoint;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Configuration;
import android.util.Log;
import androidx.annotation.Nullable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class AppLike {
    private static final String TAG = "AppJoint/AppLike";
    private List<String> mApplicationClassNames = new ArrayList<String>();
    private List<Application> mApplications = new ArrayList<Application>();
    private Context mBase;

    private AppLike() {
    }

    public static AppLike getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Nullable
    public Application getContext() {
        return null == this.mBase ? null : (Application)this.mBase.getApplicationContext();
    }

    public synchronized void attachBaseContext(Context base) {
        this.mBase = base;
        for (Application application : this.mApplications) {
            try {
                Method attachBaseContext = ContextWrapper.class.getDeclaredMethod("attachBaseContext", Context.class);
                attachBaseContext.setAccessible(true);
                attachBaseContext.invoke((Object)application, base);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public synchronized void onCreate() {
        for (Application application : this.mApplications) {
            application.onCreate();
        }
    }

    public synchronized void onTerminate() {
        for (Application application : this.mApplications) {
            application.onTerminate();
        }
    }

    public synchronized void onConfigurationChanged(Configuration newConfig) {
        for (Application application : this.mApplications) {
            application.onConfigurationChanged(newConfig);
        }
    }

    public synchronized void onLowMemory() {
        for (Application application : this.mApplications) {
            application.onLowMemory();
        }
    }

    public synchronized void onTrimMemory(int level) {
        for (Application application : this.mApplications) {
            application.onTrimMemory(level);
        }
    }

    private synchronized void addModuleAppName(String className) {
        this.mApplicationClassNames.add(className);
    }

    private synchronized void initModuleApp() {
        for (String name : this.mApplicationClassNames) {
            String className = name.replaceAll("/", ".");
            try {
                this.mApplications.add((Application)Class.forName(className).newInstance());
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)("failed to add application: " + className));
            }
        }
    }

    private static class SingletonHolder {
        @SuppressLint(value={"StaticFieldLeak"})
        private static final AppLike INSTANCE = new AppLike();

        private SingletonHolder() {
        }
    }
}

