/*
 * Decompiled with CFR 0.152.
 */
package com.jlefebure.spring.boot.minio;

import com.jlefebure.spring.boot.minio.MinioConfigurationProperties;
import io.minio.BucketExistsArgs;
import io.minio.MinioClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementContextAutoConfiguration;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.stereotype.Component;

@ConditionalOnClass(value={ManagementContextAutoConfiguration.class})
@Component
public class MinioHealthIndicator
implements HealthIndicator {
    private final MinioClient minioClient;
    private final MinioConfigurationProperties minioConfigurationProperties;

    @Autowired
    public MinioHealthIndicator(MinioClient minioClient, MinioConfigurationProperties minioConfigurationProperties) {
        this.minioClient = minioClient;
        this.minioConfigurationProperties = minioConfigurationProperties;
    }

    public Health health() {
        if (this.minioClient == null) {
            return Health.down().build();
        }
        try {
            BucketExistsArgs args = (BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(this.minioConfigurationProperties.getBucket())).build();
            if (this.minioClient.bucketExists(args)) {
                return Health.up().withDetail("bucketName", (Object)this.minioConfigurationProperties.getBucket()).build();
            }
            return Health.down().withDetail("bucketName", (Object)this.minioConfigurationProperties.getBucket()).build();
        }
        catch (Exception e) {
            return Health.down((Exception)e).withDetail("bucketName", (Object)this.minioConfigurationProperties.getBucket()).build();
        }
    }
}

