/*
 * Decompiled with CFR 0.152.
 */
package com.jlefebure.spring.boot.minio;

import com.jlefebure.spring.boot.minio.MinioConfiguration;
import com.jlefebure.spring.boot.minio.MinioConfigurationProperties;
import com.jlefebure.spring.boot.minio.MinioMetricConfiguration;
import com.jlefebure.spring.boot.minio.notification.MinioNotification;
import io.minio.CloseableIterator;
import io.minio.ListenBucketNotificationArgs;
import io.minio.MinioClient;
import io.minio.Result;
import io.minio.messages.NotificationRecords;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(value={MinioMetricConfiguration.class})
@AutoConfigureAfter(value={MinioConfiguration.class})
public class MinioNotificationConfiguration
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinioNotificationConfiguration.class);
    private final MinioClient minioClient;
    private final MinioConfigurationProperties minioConfigurationProperties;
    private List<Thread> handlers = new ArrayList<Thread>();

    @Autowired
    public MinioNotificationConfiguration(MinioClient minioClient, MinioConfigurationProperties minioConfigurationProperties) {
        this.minioClient = minioClient;
        this.minioConfigurationProperties = minioConfigurationProperties;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        for (String beanName : applicationContext.getBeanDefinitionNames()) {
            Object obj = applicationContext.getBean(beanName);
            Class objClz = obj.getClass();
            if (AopUtils.isAopProxy((Object)obj)) {
                objClz = AopUtils.getTargetClass((Object)obj);
            }
            for (Method m : objClz.getDeclaredMethods()) {
                if (!m.isAnnotationPresent(MinioNotification.class)) continue;
                if (m.getParameterCount() != 1) {
                    throw new IllegalArgumentException("Minio notification handler should have only one NotificationInfo parameter");
                }
                if (m.getParameterTypes()[0] != NotificationRecords.class) {
                    throw new IllegalArgumentException("Parameter should be instance of NotificationRecords");
                }
                MinioNotification annotation = m.getAnnotation(MinioNotification.class);
                Thread handler = new Thread(() -> {
                    try {
                        block9: while (true) {
                            LOGGER.info("Registering Minio handler on {} with notification {}", (Object)m.getName(), (Object)Arrays.toString(annotation.value()));
                            ListenBucketNotificationArgs args = (ListenBucketNotificationArgs)((ListenBucketNotificationArgs.Builder)ListenBucketNotificationArgs.builder().bucket(this.minioConfigurationProperties.getBucket())).prefix(annotation.prefix()).suffix(annotation.suffix()).events(annotation.value()).build();
                            CloseableIterator list = this.minioClient.listenBucketNotification(args);
                            block10: while (true) {
                                while (true) {
                                    if (!list.hasNext()) continue block9;
                                    NotificationRecords info = (NotificationRecords)((Result)list.next()).get();
                                    try {
                                        LOGGER.debug("Receive notification for method {}", (Object)m.getName());
                                        m.invoke(obj, info);
                                        continue block10;
                                    }
                                    catch (IllegalAccessException | InvocationTargetException e) {
                                        LOGGER.error("Error while handling notification for method {} with notification {}", (Object)m.getName(), (Object)Arrays.toString(annotation.value()));
                                        LOGGER.error("Exception is", (Throwable)e);
                                        continue;
                                    }
                                    break;
                                }
                            }
                            finally {
                                if (list == null) continue;
                                list.close();
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Error while registering notification for method " + m.getName() + " with notification " + Arrays.toString(annotation.value()), (Throwable)e);
                        throw new IllegalStateException("Cannot register handler", e);
                    }
                });
                handler.start();
                this.handlers.add(handler);
            }
        }
    }
}

