/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.traitor.framework;

import com.jnape.palatable.traitor.framework.Subjects;
import com.jnape.palatable.traitor.framework.exception.TraitFrameworkMethodSynthesisException;
import com.jnape.palatable.traitor.traits.Trait;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.junit.runners.model.FrameworkMethod;

public class TraitFrameworkMethod
extends FrameworkMethod {
    private static final String TEST_METHOD_NAME = "test";
    private final Class<?> traitClass;
    private final Object testSubject;

    TraitFrameworkMethod(Method method, Class<?> traitClass, Object testSubject) {
        super(method);
        this.traitClass = traitClass;
        this.testSubject = testSubject;
    }

    public Object invokeExplosively(Object target, Object ... params) throws Throwable {
        try {
            Method method = this.getMethod();
            Subjects<Object> subjects = this.testSubject instanceof Subjects ? (Subjects<Object>)this.testSubject : Subjects.subjects(this.testSubject);
            for (Object t : subjects) {
                method.invoke(this.traitClass.newInstance(), t);
            }
            return null;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public String getName() {
        return String.format("Trait: %s", this.traitClass.getSimpleName());
    }

    public boolean equals(Object other) {
        return other instanceof TraitFrameworkMethod && super.equals(other) && this.traitClass.equals(((TraitFrameworkMethod)((Object)other)).traitClass);
    }

    public static TraitFrameworkMethod synthesize(Class<? extends Trait> traitClass, Object testSubject) throws TraitFrameworkMethodSynthesisException {
        try {
            return new TraitFrameworkMethod(traitClass.getDeclaredMethod(TEST_METHOD_NAME, Object.class), traitClass, testSubject);
        }
        catch (NoSuchMethodException e) {
            try {
                return new TraitFrameworkMethod(traitClass.getMethod(TEST_METHOD_NAME, Object.class), traitClass, testSubject);
            }
            catch (Exception ex) {
                throw new TraitFrameworkMethodSynthesisException(traitClass, (Throwable)ex);
            }
        }
        catch (Exception e) {
            throw new TraitFrameworkMethodSynthesisException(traitClass, (Throwable)e);
        }
    }
}

