/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.traitor.runners;

import com.jnape.palatable.traitor.annotations.TestTraits;
import com.jnape.palatable.traitor.framework.TraitFrameworkMethod;
import com.jnape.palatable.traitor.traits.Trait;
import java.util.List;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;

public class Traits
extends BlockJUnit4ClassRunner {
    public Traits(Class<?> testClass) throws InitializationError {
        super(testClass);
    }

    protected List<FrameworkMethod> computeTestMethods() {
        List testMethods = super.computeTestMethods();
        this.addTraitTestingMethods(testMethods);
        return testMethods;
    }

    private void addTraitTestingMethods(List<FrameworkMethod> testMethods) {
        List traitTestSubjectCreationMethods = this.getTestClass().getAnnotatedMethods(TestTraits.class);
        for (FrameworkMethod traitTestSubjectCreationMethod : traitTestSubjectCreationMethods) {
            try {
                Object testSubject = traitTestSubjectCreationMethod.invokeExplosively(this.createTest(), new Object[0]);
                for (Class<? extends Trait> traitClass : ((TestTraits)traitTestSubjectCreationMethod.getAnnotation(TestTraits.class)).value()) {
                    TraitFrameworkMethod traitFrameworkMethod = TraitFrameworkMethod.synthesize(traitClass, testSubject);
                    testMethods.remove((Object)traitFrameworkMethod);
                    testMethods.add(traitFrameworkMethod);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new AssertionError((Object)"Couldn't create a test subject");
            }
        }
    }
}

