/*
 * Decompiled with CFR 0.152.
 */
package com.joanzapata.pdfview;

import android.graphics.Bitmap;
import android.graphics.RectF;
import android.os.AsyncTask;
import com.joanzapata.pdfview.PDFView;
import com.joanzapata.pdfview.model.PagePart;
import java.util.ArrayList;
import java.util.List;
import org.vudroid.core.DecodeService;
import org.vudroid.core.codec.CodecPage;

class RenderingAsyncTask
extends AsyncTask<Void, PagePart, Void> {
    private DecodeService decodeService;
    private List<RenderingTask> renderingTasks;
    private PDFView pdfView;

    public RenderingAsyncTask(PDFView pdfView) {
        this.pdfView = pdfView;
        this.renderingTasks = new ArrayList<RenderingTask>();
    }

    public void addRenderingTask(int userPage, int page, float width, float height, RectF bounds, boolean thumbnail, int cacheOrder) {
        RenderingTask task = new RenderingTask(width, height, bounds, userPage, page, thumbnail, cacheOrder);
        this.renderingTasks.add(task);
        this.wakeUp();
    }

    protected void onPreExecute() {
    }

    protected Void doInBackground(Void ... params) {
        while (!this.isCancelled()) {
            while (!this.renderingTasks.isEmpty()) {
                RenderingTask task = this.renderingTasks.get(0);
                PagePart part = this.proceed(task);
                if (this.renderingTasks.remove(task)) {
                    this.publishProgress(new PagePart[]{part});
                    continue;
                }
                part.getRenderedBitmap().recycle();
            }
            if (this.waitForRenderingTasks() && !this.isCancelled()) continue;
            return null;
        }
        return null;
    }

    protected void onProgressUpdate(PagePart ... part) {
        this.pdfView.onBitmapRendered(part[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForRenderingTasks() {
        try {
            List<RenderingTask> list = this.renderingTasks;
            synchronized (list) {
                this.renderingTasks.wait();
            }
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PagePart proceed(RenderingTask renderingTask) {
        Bitmap render;
        this.decodeService = this.pdfView.getDecodeService();
        CodecPage page = this.decodeService.getPage(renderingTask.page);
        Class<?> clazz = this.decodeService.getClass();
        synchronized (clazz) {
            render = page.renderBitmap(Math.round(renderingTask.width), Math.round(renderingTask.height), renderingTask.bounds);
        }
        PagePart part = new PagePart(renderingTask.userPage, renderingTask.page, render, renderingTask.width, renderingTask.height, renderingTask.bounds, renderingTask.thumbnail, renderingTask.cacheOrder);
        return part;
    }

    public void removeAllTasks() {
        this.renderingTasks.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp() {
        List<RenderingTask> list = this.renderingTasks;
        synchronized (list) {
            this.renderingTasks.notify();
        }
    }

    private class RenderingTask {
        float width;
        float height;
        RectF bounds;
        int page;
        int userPage;
        boolean thumbnail;
        int cacheOrder;

        public RenderingTask(float width, float height, RectF bounds, int userPage, int page, boolean thumbnail, int cacheOrder) {
            this.page = page;
            this.width = width;
            this.height = height;
            this.bounds = bounds;
            this.userPage = userPage;
            this.thumbnail = thumbnail;
            this.cacheOrder = cacheOrder;
        }
    }
}

