/*
 * Decompiled with CFR 0.152.
 */
package com.joestelmach.natty;

import com.joestelmach.natty.ANTLRNoCaseInputStream;
import com.joestelmach.natty.ParseListener;
import com.joestelmach.natty.ParseResult;
import com.joestelmach.natty.generated.DateLexer;
import com.joestelmach.natty.generated.DateParser;
import com.joestelmach.natty.generated.DateWalker;
import com.joestelmach.natty.generated.DebugDateParser;
import com.joestelmach.natty.generated.TreeRewrite;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.ParserRuleReturnScope;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.debug.DebugEventListener;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeNodeStream;

public class Parser {
    private TimeZone _defaultTimeZone;
    private boolean _debug;
    private ParseListener _debugListener;
    private static final Logger _logger = Logger.getLogger(Parser.class.getName());

    public Parser(TimeZone defaultTimeZone) {
        this._defaultTimeZone = defaultTimeZone;
    }

    public Parser() {
        this._defaultTimeZone = TimeZone.getTimeZone("America/New_York");
    }

    public void setDebug(boolean debug) {
        this._debug = debug;
    }

    public ParseResult parse(String inputString) {
        ParseResult result = new ParseResult();
        try {
            ParserRuleReturnScope parseReturn;
            Object parser;
            ANTLRNoCaseInputStream input = new ANTLRNoCaseInputStream(new ByteArrayInputStream(inputString.trim().getBytes()));
            DateLexer lexer = new DateLexer((CharStream)input);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            Tree tree = null;
            if (this._debug) {
                this._debugListener = new ParseListener();
                parser = new DebugDateParser((TokenStream)tokens, (DebugEventListener)this._debugListener);
                parseReturn = ((DebugDateParser)((Object)parser)).parse();
                tree = (Tree)parseReturn.getTree();
                result.setParseLocations(this._debugListener.getLocations());
            } else {
                parser = new DateParser((TokenStream)tokens);
                parseReturn = ((DateParser)((Object)parser)).parse();
                tree = (Tree)parseReturn.getTree();
            }
            CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)tree);
            TreeRewrite s = new TreeRewrite((TreeNodeStream)nodes);
            tree = (CommonTree)s.downup(tree);
            result.setSyntaxTree(tree.toStringTree());
            nodes = new CommonTreeNodeStream((Object)tree);
            nodes.setTokenStream((TokenStream)tokens);
            DateWalker walker = new DateWalker((TreeNodeStream)nodes);
            walker.getState().setDefaultTimeZone(this._defaultTimeZone);
            walker.date_time_alternative();
            result.setDateTimes(walker.getState().getDateTimes());
        }
        catch (IOException e) {
            _logger.log(Level.SEVERE, "Could not read from input stream", e);
        }
        catch (RecognitionException e) {
            _logger.log(Level.SEVERE, "Could not parse input", e);
        }
        return result;
    }
}

