/*
 * Decompiled with CFR 0.152.
 */
package com.joestelmach.natty;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WalkerState {
    private GregorianCalendar _calendar;
    private TimeZone _defaultTimeZone;
    private int _currentYear;
    private static final int TWO_DIGIT_YEAR_CENTURY_THRESHOLD = 20;
    private List<Date> _currentDateTimes;

    public WalkerState() {
        this.resetCalender();
        this._currentDateTimes = new ArrayList<Date>();
    }

    public void setDefaultTimeZone(TimeZone zone) {
        this._defaultTimeZone = zone;
    }

    public void seekToDayOfWeek(String direction, String seekType, String seekAmount, String dayOfWeek) {
        int sign;
        int dayOfWeekInt = Integer.parseInt(dayOfWeek);
        int seekAmountInt = Integer.parseInt(seekAmount);
        assert (direction.equals("<") || direction.equals(">"));
        assert (seekType.equals("by_day") || seekType.equals("by_week"));
        assert (dayOfWeekInt >= 1 && dayOfWeekInt <= 7);
        int n = sign = direction.equals(">") ? 1 : -1;
        if (seekType.equals("by_week")) {
            this._calendar.set(7, dayOfWeekInt);
            this._calendar.add(6, seekAmountInt * 7 * sign);
        } else if (seekType.equals("by_day")) {
            do {
                this._calendar.roll(6, sign);
            } while (this._calendar.get(7) != dayOfWeekInt);
            if (seekAmountInt > 0) {
                this._calendar.add(3, (seekAmountInt - 1) * sign);
            }
        }
    }

    public void seekToDayOfMonth(String dayOfMonth) {
        int dayOfMonthInt = Integer.parseInt(dayOfMonth);
        assert (dayOfMonthInt >= 1 && dayOfMonthInt <= 31);
        this._calendar.set(5, dayOfMonthInt);
    }

    public void seekToMonth(String direction, String seekAmount, String month) {
        int sign;
        int seekAmountInt = Integer.parseInt(seekAmount);
        int monthInt = Integer.parseInt(month);
        assert (direction.equals("<") || direction.equals(">"));
        assert (monthInt >= 1 && monthInt <= 12);
        int currentMonth = this._calendar.get(2) + 1;
        int n = sign = direction.equals(">") ? 1 : -1;
        int numYearsToShift = seekAmountInt + (currentMonth <= monthInt ? (sign > 0 ? -1 : 0) : (sign > 0 ? 0 : -1));
        this._calendar.add(1, numYearsToShift * sign);
        this._calendar.set(2, monthInt - 1);
    }

    public void seekBySpan(String direction, String seekAmount, String span) {
        int field;
        int sign;
        int seekAmountInt = Integer.parseInt(seekAmount);
        assert (direction.equals("<") || direction.equals(">"));
        assert (span.equals("day") || span.equals("week") || span.equals("month") || span.equals("year"));
        int n = sign = direction.equals(">") ? 1 : -1;
        int n2 = span.equals("day") ? 6 : (span.equals("week") ? 3 : (span.equals("month") ? 2 : (field = (span.equals("year") ? Integer.valueOf(1) : null).intValue())));
        if (field > 0) {
            this._calendar.add(field, seekAmountInt * sign);
        }
    }

    public void setDayOfWeekIndex(String index, String dayOfWeek) {
        int indexInt = Integer.parseInt(index);
        assert (indexInt > 0 && indexInt < 6);
        int dayOfWeekInt = Integer.parseInt(dayOfWeek);
        assert (dayOfWeekInt >= 1 && dayOfWeekInt <= 7);
        this._calendar.set(5, 1);
        if (this._calendar.get(7) > dayOfWeekInt) {
            this._calendar.add(4, 1);
        }
        this._calendar.set(7, dayOfWeekInt);
        int currentMonth = this._calendar.get(2);
        this._calendar.add(4, indexInt - 1);
        if (currentMonth != this._calendar.get(2)) {
            this._calendar.add(4, -1);
        }
    }

    public void setExplicitDate(String month, String dayOfMonth, String dayOfWeek, String year) {
        int monthInt = Integer.parseInt(month);
        assert (monthInt > 0 && monthInt <= 12);
        int dayOfMonthInt = Integer.parseInt(dayOfMonth);
        assert (dayOfMonthInt > 0 && dayOfMonthInt <= 31);
        this._calendar.set(2, monthInt - 1);
        this._calendar.set(5, dayOfMonthInt);
        int yearInt = -1;
        if (year != null) {
            yearInt = Integer.parseInt(year);
            assert (yearInt > 0 && yearInt < 9999);
            if (year.length() == 2) {
                int century = yearInt > this._currentYear - 2000 + 20 ? 1900 : 2000;
                yearInt += century;
            }
            this._calendar.set(1, yearInt);
        } else if (dayOfWeek != null) {
            int dayOfWeekInt = Integer.parseInt(dayOfWeek);
            assert (dayOfWeekInt >= 1 && dayOfWeekInt <= 7);
            while (this._calendar.get(7) != dayOfWeekInt) {
                this._calendar.roll(1, false);
            }
        }
    }

    public void setExplicitTime(String hours, String minutes, String seconds, String amPm, String zoneString) {
        int hoursInt = Integer.parseInt(hours);
        int minutesInt = Integer.parseInt(minutes);
        assert (amPm == null || amPm.equals("am") || amPm.equals("pm"));
        assert (hoursInt >= 0 && hoursInt <= 23);
        assert (minutesInt >= 0 && minutesInt < 60);
        this._calendar.set(14, 0);
        TimeZone zone = null;
        if (zoneString != null) {
            if (zoneString.startsWith("+") || zoneString.startsWith("-")) {
                zoneString = "GMT" + zoneString;
            }
            zone = TimeZone.getTimeZone(zoneString);
        }
        this._calendar.setTimeZone(zone != null ? zone : this._defaultTimeZone);
        this._calendar.set(11, hoursInt);
        if (hoursInt <= 12) {
            int amPmInt = amPm == null ? (hoursInt > 12 ? 1 : 0) : (amPm.equals("pm") ? 1 : 0);
            this._calendar.set(9, amPmInt);
            if (hoursInt == 12) {
                hoursInt = 0;
            }
            this._calendar.set(10, hoursInt);
        }
        if (seconds != null) {
            int secondsInt = Integer.parseInt(seconds);
            assert (secondsInt >= 0 && secondsInt < 60);
            this._calendar.set(13, secondsInt);
        }
        this._calendar.set(12, minutesInt);
    }

    public void captureDateTime() {
        Date date = this._calendar.getTime();
        this._currentDateTimes.add(date);
        this.resetCalender();
    }

    public List<Date> getDateTimes() {
        return this._currentDateTimes;
    }

    private void resetCalender() {
        this._calendar = new GregorianCalendar();
        this._currentYear = this._calendar.get(1);
    }
}

