/*
 * Decompiled with CFR 0.152.
 */
package com.joestelmach.natty;

import com.joestelmach.natty.CalendarSource;
import com.joestelmach.natty.DateGroup;
import com.joestelmach.natty.Holiday;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WalkerState {
    private static final int TWO_DIGIT_YEAR_CENTURY_THRESHOLD = 20;
    private static final String MONTH = "month";
    private static final String DAY = "day";
    private static final String YEAR = "year";
    private static final String WEEK = "week";
    private static final String HOUR = "hour";
    private static final String MINUTE = "minute";
    private static final String SECOND = "second";
    private static final String AM = "am";
    private static final String PM = "pm";
    private static final String DIR_LEFT = "<";
    private static final String DIR_RIGHT = ">";
    private static final String SEEK_PREFIX = "by_";
    private static final String SEEK_BY_DAY = "by_day";
    private static final String SEEK_BY_WEEK = "by_week";
    private static final String PLUS = "+";
    private static final String MINUS = "-";
    private static final String GMT = "GMT";
    private static final String VEVENT = "VEVENT";
    private static final String SUMMARY = "SUMMARY";
    private static final String HOLIDAY_ICS_FILE = "/holidays.ics";
    private static final Logger _logger = Logger.getLogger("com.joestelmach.natty");
    private GregorianCalendar _calendar;
    private TimeZone _defaultTimeZone;
    private int _currentYear;
    private boolean _firstDateInvocationInGroup = true;
    private boolean _timeGivenInGroup = false;
    private Calendar _holidayCalendar;
    private DateGroup _dateGroup;

    public WalkerState() {
        this.resetCalendar();
        this._dateGroup = new DateGroup();
    }

    public void setDefaultTimeZone(TimeZone zone) {
        this._defaultTimeZone = zone;
        this.resetCalendar();
    }

    public void seekToDayOfWeek(String direction, String seekType, String seekAmount, String dayOfWeek) {
        int sign;
        int dayOfWeekInt = Integer.parseInt(dayOfWeek);
        int seekAmountInt = Integer.parseInt(seekAmount);
        assert (direction.equals(DIR_LEFT) || direction.equals(DIR_RIGHT));
        assert (seekType.equals(SEEK_BY_DAY) || seekType.equals(SEEK_BY_WEEK));
        assert (dayOfWeekInt >= 1 && dayOfWeekInt <= 7);
        this.markDateInvocation();
        int n = sign = direction.equals(DIR_RIGHT) ? 1 : -1;
        if (seekType.equals(SEEK_BY_WEEK)) {
            this._calendar.set(7, dayOfWeekInt);
            this._calendar.add(6, seekAmountInt * 7 * sign);
        } else if (seekType.equals(SEEK_BY_DAY)) {
            do {
                this._calendar.roll(6, sign);
            } while (this._calendar.get(7) != dayOfWeekInt);
            if (seekAmountInt > 0) {
                this._calendar.add(3, (seekAmountInt - 1) * sign);
            }
        }
    }

    public void seekToDayOfMonth(String dayOfMonth) {
        int dayOfMonthInt = Integer.parseInt(dayOfMonth);
        assert (dayOfMonthInt >= 1 && dayOfMonthInt <= 31);
        this.markDateInvocation();
        dayOfMonthInt = Math.min(dayOfMonthInt, this._calendar.getActualMaximum(5));
        this._calendar.set(5, dayOfMonthInt);
    }

    public void seekToDayOfYear(String dayOfYear) {
        int dayOfYearInt = Integer.parseInt(dayOfYear);
        assert (dayOfYearInt >= 1 && dayOfYearInt <= 366);
        this.markDateInvocation();
        dayOfYearInt = Math.min(dayOfYearInt, this._calendar.getActualMaximum(6));
        this._calendar.set(6, dayOfYearInt);
    }

    public void seekToYear(String year) {
        int yearInt = Integer.parseInt(year);
        assert (yearInt > 0 && yearInt < 9999);
        this.markDateInvocation();
        this._calendar.set(1, this.getFullYear(yearInt));
    }

    public void seekToMonth(String direction, String seekAmount, String month) {
        int seekAmountInt = Integer.parseInt(seekAmount);
        int monthInt = Integer.parseInt(month);
        assert (direction.equals(DIR_LEFT) || direction.equals(DIR_RIGHT));
        assert (monthInt >= 1 && monthInt <= 12);
        this.markDateInvocation();
        this._calendar.set(5, 1);
        if (seekAmountInt > 0) {
            int sign;
            int currentMonth = this._calendar.get(2) + 1;
            int n = sign = direction.equals(DIR_RIGHT) ? 1 : -1;
            int numYearsToShift = seekAmountInt + (currentMonth <= monthInt ? (sign > 0 ? -1 : 0) : (sign > 0 ? 0 : -1));
            this._calendar.add(1, numYearsToShift * sign);
        }
        this._calendar.set(2, monthInt - 1);
    }

    public void seekBySpan(String direction, String seekAmount, String span) {
        int field;
        int sign;
        boolean isDateSeek;
        if (span.startsWith(SEEK_PREFIX)) {
            span = span.substring(3);
        }
        int seekAmountInt = Integer.parseInt(seekAmount);
        assert (direction.equals(DIR_LEFT) || direction.equals(DIR_RIGHT));
        assert (span.equals(DAY) || span.equals(WEEK) || span.equals(MONTH) || span.equals(YEAR) || span.equals(HOUR) || span.equals(MINUTE) || span.equals(SECOND));
        boolean bl = isDateSeek = span.equals(DAY) || span.equals(WEEK) || span.equals(MONTH) || span.equals(YEAR);
        if (isDateSeek) {
            this.markDateInvocation();
        } else {
            this.markTimeInvocation();
        }
        int n = sign = direction.equals(DIR_RIGHT) ? 1 : -1;
        int n2 = span.equals(DAY) ? 6 : (span.equals(WEEK) ? 3 : (span.equals(MONTH) ? 2 : (span.equals(YEAR) ? 1 : (span.equals(HOUR) ? 10 : (span.equals(MINUTE) ? 12 : (field = (span.equals(SECOND) ? Integer.valueOf(13) : null).intValue()))))));
        if (field > 0) {
            this._calendar.add(field, seekAmountInt * sign);
        }
    }

    public void setDayOfWeekIndex(String index, String dayOfWeek) {
        int indexInt = Integer.parseInt(index);
        assert (indexInt > 0 && indexInt < 6);
        int dayOfWeekInt = Integer.parseInt(dayOfWeek);
        assert (dayOfWeekInt >= 1 && dayOfWeekInt <= 7);
        this.markDateInvocation();
        this._calendar.set(5, 1);
        if (this._calendar.get(7) > dayOfWeekInt) {
            this._calendar.add(4, 1);
        }
        this._calendar.set(7, dayOfWeekInt);
        int currentMonth = this._calendar.get(2);
        this._calendar.add(4, indexInt - 1);
        if (currentMonth != this._calendar.get(2)) {
            this._calendar.add(4, -1);
        }
    }

    public void setExplicitDate(String month, String dayOfMonth, String dayOfWeek, String year) {
        int monthInt = Integer.parseInt(month);
        assert (monthInt > 0 && monthInt <= 12);
        int dayOfMonthInt = Integer.parseInt(dayOfMonth);
        assert (dayOfMonthInt > 0 && dayOfMonthInt <= 31);
        this.markDateInvocation();
        this._calendar.set(2, monthInt - 1);
        this._calendar.set(5, dayOfMonthInt);
        if (year != null) {
            this.seekToYear(year);
        } else if (dayOfWeek != null) {
            int dayOfWeekInt = Integer.parseInt(dayOfWeek);
            assert (dayOfWeekInt >= 1 && dayOfWeekInt <= 7);
            while (this._calendar.get(7) != dayOfWeekInt) {
                this._calendar.roll(1, false);
            }
        }
    }

    public void setExplicitTime(String hours, String minutes, String seconds, String amPm, String zoneString) {
        int hoursInt = Integer.parseInt(hours);
        int minutesInt = Integer.parseInt(minutes);
        assert (amPm == null || amPm.equals(AM) || amPm.equals(PM));
        assert (hoursInt >= 0 && hoursInt <= 23);
        assert (minutesInt >= 0 && minutesInt < 60);
        this.markTimeInvocation();
        this._calendar.set(14, 0);
        TimeZone zone = null;
        if (zoneString != null) {
            if (zoneString.startsWith(PLUS) || zoneString.startsWith(MINUS)) {
                zoneString = GMT + zoneString;
            }
            zone = TimeZone.getTimeZone(zoneString);
        }
        this._calendar.setTimeZone(zone != null ? zone : this._defaultTimeZone);
        this._calendar.set(11, hoursInt);
        if (hoursInt <= 12) {
            int amPmInt = amPm == null ? (hoursInt >= 12 ? 1 : 0) : (amPm.equals(PM) ? 1 : 0);
            this._calendar.set(9, amPmInt);
            if (hoursInt == 12) {
                hoursInt = 0;
            }
            this._calendar.set(10, hoursInt);
        }
        if (seconds != null) {
            int secondsInt = Integer.parseInt(seconds);
            assert (secondsInt >= 0 && secondsInt < 60);
            this._calendar.set(13, secondsInt);
        } else {
            this._calendar.set(13, 0);
        }
        this._calendar.set(12, minutesInt);
    }

    public void seekToHoliday(String holidayString, String direction, String seekAmount) {
        Holiday holiday = Holiday.valueOf(holidayString);
        int seekAmountInt = Integer.parseInt(seekAmount);
        assert (direction.equals(DIR_LEFT) || direction.equals(DIR_RIGHT));
        assert (seekAmountInt >= 0);
        assert (holiday != null);
        this.markDateInvocation();
        GregorianCalendar cal = this.getCalendar();
        ((java.util.Calendar)cal).setTimeZone(this._defaultTimeZone);
        int currentYear = cal.get(1);
        boolean forwards = direction.equals(DIR_RIGHT);
        int startYear = forwards ? currentYear : currentYear - seekAmountInt - 1;
        int endYear = forwards ? currentYear + seekAmountInt + 1 : currentYear;
        Map<Integer, Date> dates = this.getDatesForHoliday(startYear, endYear, holiday);
        boolean hasPassed = cal.getTime().after(dates.get(currentYear));
        int targetYear = currentYear + (forwards ? seekAmountInt + (hasPassed ? 0 : -1) : (seekAmountInt - (hasPassed ? 1 : 0)) * -1);
        ((java.util.Calendar)cal).setTimeZone(this._calendar.getTimeZone());
        cal.setTime(dates.get(targetYear));
        this._calendar.set(1, cal.get(1));
        this._calendar.set(2, cal.get(2));
        this._calendar.set(5, cal.get(5));
    }

    public void seekToHolidayYear(String holidayString, String yearString) {
        Holiday holiday = Holiday.valueOf(holidayString);
        int yearInt = Integer.parseInt(yearString);
        assert (holiday != null);
        assert (yearInt >= 0);
        this.markDateInvocation();
        int year = this.getFullYear(yearInt);
        Map<Integer, Date> dates = this.getDatesForHoliday(year, year, holiday);
        Date date = dates.get(year - (holiday.equals((Object)Holiday.NEW_YEARS_EVE) ? 1 : 0));
        if (date != null) {
            GregorianCalendar cal = this.getCalendar();
            ((java.util.Calendar)cal).setTimeZone(this._calendar.getTimeZone());
            cal.setTime(date);
            this._calendar.set(1, cal.get(1));
            this._calendar.set(2, cal.get(2));
            this._calendar.set(5, cal.get(5));
        }
    }

    public void setRecurring() {
        this._dateGroup.setRecurring(true);
    }

    public void captureDateTime() {
        Date date = this._calendar.getTime();
        if (this._dateGroup.isRecurring()) {
            this._dateGroup.setRecurringUntil(date);
        } else {
            this._dateGroup.addDate(date);
        }
        this._firstDateInvocationInGroup = true;
    }

    public DateGroup getDateGroup() {
        return this._dateGroup;
    }

    public void clearDateGroup() {
        this._dateGroup = new DateGroup();
    }

    private void resetCalendar() {
        this._calendar = this.getCalendar();
        if (this._defaultTimeZone != null) {
            this._calendar.setTimeZone(this._defaultTimeZone);
        }
        this._currentYear = this._calendar.get(1);
    }

    private void markDateInvocation() {
        if (this._firstDateInvocationInGroup) {
            if (this._timeGivenInGroup) {
                int hours = this._calendar.get(11);
                int minutes = this._calendar.get(12);
                int seconds = this._calendar.get(13);
                this.resetCalendar();
                this._calendar.set(11, hours);
                this._calendar.set(12, minutes);
                this._calendar.set(13, seconds);
            } else {
                this.resetCalendar();
            }
            this._firstDateInvocationInGroup = false;
        }
    }

    private void markTimeInvocation() {
        this._timeGivenInGroup = true;
    }

    private Map<Integer, Date> getDatesForHoliday(int startYear, int endYear, Holiday holiday) {
        HashMap<Integer, Date> holidays = new HashMap<Integer, Date>();
        if (this._holidayCalendar == null) {
            InputStream fin = WalkerState.class.getResourceAsStream(HOLIDAY_ICS_FILE);
            try {
                this._holidayCalendar = new CalendarBuilder().build(fin);
            }
            catch (IOException e) {
                _logger.severe("Couln't open /holidays.ics");
                return holidays;
            }
            catch (ParserException e) {
                _logger.severe("Couln't parse /holidays.ics");
                return holidays;
            }
        }
        Period period = null;
        try {
            DateTime from = new DateTime(startYear + "0101T000000Z");
            DateTime to = new DateTime(endYear + "1231T000000Z");
            period = new Period(from, to);
        }
        catch (ParseException e) {
            _logger.log(Level.SEVERE, "Invalid start or end year: " + startYear + ", " + endYear, e);
            return holidays;
        }
        for (Object component : this._holidayCalendar.getComponents(VEVENT)) {
            Component vevent = (Component)component;
            String summary = vevent.getProperty(SUMMARY).getValue();
            if (!summary.equals(holiday.getSummary())) continue;
            PeriodList list = vevent.calculateRecurrenceSet(period);
            for (Object p : list) {
                DateTime date = ((Period)p).getStart();
                GregorianCalendar utcCal = this.getCalendar();
                ((java.util.Calendar)utcCal).setTimeZone(TimeZone.getTimeZone(GMT));
                utcCal.setTime((Date)date);
                GregorianCalendar localCal = this.getCalendar();
                ((java.util.Calendar)localCal).setTimeZone(this._defaultTimeZone);
                localCal.set(1, utcCal.get(1));
                localCal.set(2, utcCal.get(2));
                localCal.set(5, utcCal.get(5));
                holidays.put(localCal.get(1), localCal.getTime());
            }
        }
        return holidays;
    }

    private int getFullYear(Integer year) {
        int result = year;
        if (year.toString().length() <= 2) {
            int century = year > this._currentYear - 2000 + 20 ? 1900 : 2000;
            result = year + century;
        }
        return result;
    }

    protected GregorianCalendar getCalendar() {
        return CalendarSource.getCurrentCalendar();
    }
}

