/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.llama;

import com.johnsnowlabs.nlp.llama.JsonParameters;
import com.johnsnowlabs.nlp.llama.args.MiroStat;
import com.johnsnowlabs.nlp.llama.args.Sampler;
import java.util.Collection;
import java.util.Map;

public final class InferenceParameters
extends JsonParameters {
    private static final String PARAM_PROMPT = "prompt";
    private static final String PARAM_INPUT_PREFIX = "input_prefix";
    private static final String PARAM_INPUT_SUFFIX = "input_suffix";
    private static final String PARAM_CACHE_PROMPT = "cache_prompt";
    private static final String PARAM_N_PREDICT = "n_predict";
    private static final String PARAM_TOP_K = "top_k";
    private static final String PARAM_TOP_P = "top_p";
    private static final String PARAM_MIN_P = "min_p";
    private static final String PARAM_TFS_Z = "tfs_z";
    private static final String PARAM_TYPICAL_P = "typical_p";
    private static final String PARAM_TEMPERATURE = "temperature";
    private static final String PARAM_DYNATEMP_RANGE = "dynatemp_range";
    private static final String PARAM_DYNATEMP_EXPONENT = "dynatemp_exponent";
    private static final String PARAM_REPEAT_LAST_N = "repeat_last_n";
    private static final String PARAM_REPEAT_PENALTY = "repeat_penalty";
    private static final String PARAM_FREQUENCY_PENALTY = "frequency_penalty";
    private static final String PARAM_PRESENCE_PENALTY = "presence_penalty";
    private static final String PARAM_MIROSTAT = "mirostat";
    private static final String PARAM_MIROSTAT_TAU = "mirostat_tau";
    private static final String PARAM_MIROSTAT_ETA = "mirostat_eta";
    private static final String PARAM_PENALIZE_NL = "penalize_nl";
    private static final String PARAM_N_KEEP = "n_keep";
    private static final String PARAM_SEED = "seed";
    private static final String PARAM_N_PROBS = "n_probs";
    private static final String PARAM_MIN_KEEP = "min_keep";
    private static final String PARAM_GRAMMAR = "grammar";
    private static final String PARAM_PENALTY_PROMPT = "penalty_prompt";
    private static final String PARAM_IGNORE_EOS = "ignore_eos";
    private static final String PARAM_LOGIT_BIAS = "logit_bias";
    private static final String PARAM_STOP = "stop";
    private static final String PARAM_SAMPLERS = "samplers";
    private static final String PARAM_STREAM = "stream";
    private static final String PARAM_USE_CHAT_TEMPLATE = "use_chat_template";
    private static final String PARAM_IMAGE_DATA = "image_data";

    public InferenceParameters(String string) {
        this.setPrompt(string);
    }

    public InferenceParameters setPrompt(String string) {
        this.parameters.put(PARAM_PROMPT, this.toJsonString(string));
        return this;
    }

    public InferenceParameters setInputPrefix(String string) {
        this.parameters.put(PARAM_INPUT_PREFIX, this.toJsonString(string));
        return this;
    }

    public InferenceParameters setInputSuffix(String string) {
        this.parameters.put(PARAM_INPUT_SUFFIX, this.toJsonString(string));
        return this;
    }

    public InferenceParameters setCachePrompt(boolean bl) {
        this.parameters.put(PARAM_CACHE_PROMPT, String.valueOf(bl));
        return this;
    }

    public InferenceParameters setNPredict(int n) {
        this.parameters.put(PARAM_N_PREDICT, String.valueOf(n));
        return this;
    }

    public InferenceParameters setTopK(int n) {
        this.parameters.put(PARAM_TOP_K, String.valueOf(n));
        return this;
    }

    public InferenceParameters setTopP(float f) {
        this.parameters.put(PARAM_TOP_P, String.valueOf(f));
        return this;
    }

    public InferenceParameters setMinP(float f) {
        this.parameters.put(PARAM_MIN_P, String.valueOf(f));
        return this;
    }

    public InferenceParameters setTfsZ(float f) {
        this.parameters.put(PARAM_TFS_Z, String.valueOf(f));
        return this;
    }

    public InferenceParameters setTypicalP(float f) {
        this.parameters.put(PARAM_TYPICAL_P, String.valueOf(f));
        return this;
    }

    public InferenceParameters setTemperature(float f) {
        this.parameters.put(PARAM_TEMPERATURE, String.valueOf(f));
        return this;
    }

    public InferenceParameters setDynamicTemperatureRange(float f) {
        this.parameters.put(PARAM_DYNATEMP_RANGE, String.valueOf(f));
        return this;
    }

    public InferenceParameters setDynamicTemperatureExponent(float f) {
        this.parameters.put(PARAM_DYNATEMP_EXPONENT, String.valueOf(f));
        return this;
    }

    public InferenceParameters setRepeatLastN(int n) {
        this.parameters.put(PARAM_REPEAT_LAST_N, String.valueOf(n));
        return this;
    }

    public InferenceParameters setRepeatPenalty(float f) {
        this.parameters.put(PARAM_REPEAT_PENALTY, String.valueOf(f));
        return this;
    }

    public InferenceParameters setFrequencyPenalty(float f) {
        this.parameters.put(PARAM_FREQUENCY_PENALTY, String.valueOf(f));
        return this;
    }

    public InferenceParameters setPresencePenalty(float f) {
        this.parameters.put(PARAM_PRESENCE_PENALTY, String.valueOf(f));
        return this;
    }

    public InferenceParameters setMiroStat(MiroStat miroStat) {
        this.parameters.put(PARAM_MIROSTAT, String.valueOf(miroStat.ordinal()));
        return this;
    }

    public InferenceParameters setMiroStatTau(float f) {
        this.parameters.put(PARAM_MIROSTAT_TAU, String.valueOf(f));
        return this;
    }

    public InferenceParameters setMiroStatEta(float f) {
        this.parameters.put(PARAM_MIROSTAT_ETA, String.valueOf(f));
        return this;
    }

    public InferenceParameters setPenalizeNl(boolean bl) {
        this.parameters.put(PARAM_PENALIZE_NL, String.valueOf(bl));
        return this;
    }

    public InferenceParameters setNKeep(int n) {
        this.parameters.put(PARAM_N_KEEP, String.valueOf(n));
        return this;
    }

    public InferenceParameters setSeed(int n) {
        this.parameters.put(PARAM_SEED, String.valueOf(n));
        return this;
    }

    public InferenceParameters setNProbs(int n) {
        this.parameters.put(PARAM_N_PROBS, String.valueOf(n));
        return this;
    }

    public InferenceParameters setMinKeep(int n) {
        this.parameters.put(PARAM_MIN_KEEP, String.valueOf(n));
        return this;
    }

    public InferenceParameters setGrammar(String string) {
        this.parameters.put(PARAM_GRAMMAR, this.toJsonString(string));
        return this;
    }

    public InferenceParameters setPenaltyPrompt(String string) {
        this.parameters.put(PARAM_PENALTY_PROMPT, this.toJsonString(string));
        return this;
    }

    public InferenceParameters setPenaltyPrompt(int[] nArray) {
        if (nArray.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            for (int i = 0; i < nArray.length; ++i) {
                stringBuilder.append(nArray[i]);
                if (i >= nArray.length - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("]");
            this.parameters.put(PARAM_PENALTY_PROMPT, stringBuilder.toString());
        }
        return this;
    }

    public InferenceParameters setIgnoreEos(boolean bl) {
        this.parameters.put(PARAM_IGNORE_EOS, String.valueOf(bl));
        return this;
    }

    public InferenceParameters setTokenIdBias(Map<Integer, Float> map) {
        if (!map.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            int n = 0;
            for (Map.Entry<Integer, Float> entry : map.entrySet()) {
                Integer n2 = entry.getKey();
                Float f = entry.getValue();
                stringBuilder.append("[").append(n2).append(", ").append(f).append("]");
                if (n++ >= map.size() - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("]");
            this.parameters.put(PARAM_LOGIT_BIAS, stringBuilder.toString());
        }
        return this;
    }

    public InferenceParameters disableTokenIds(Collection<Integer> collection) {
        if (!collection.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            int n = 0;
            for (Integer n2 : collection) {
                stringBuilder.append("[").append(n2).append(", ").append(false).append("]");
                if (n++ >= collection.size() - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("]");
            this.parameters.put(PARAM_LOGIT_BIAS, stringBuilder.toString());
        }
        return this;
    }

    public InferenceParameters setTokenBias(Map<String, Float> map) {
        if (!map.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            int n = 0;
            for (Map.Entry<String, Float> entry : map.entrySet()) {
                String string = entry.getKey();
                Float f = entry.getValue();
                stringBuilder.append("[").append(this.toJsonString(string)).append(", ").append(f).append("]");
                if (n++ >= map.size() - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("]");
            this.parameters.put(PARAM_LOGIT_BIAS, stringBuilder.toString());
        }
        return this;
    }

    public InferenceParameters disableTokens(Collection<String> collection) {
        if (!collection.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            int n = 0;
            for (String string : collection) {
                stringBuilder.append("[").append(this.toJsonString(string)).append(", ").append(false).append("]");
                if (n++ >= collection.size() - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("]");
            this.parameters.put(PARAM_LOGIT_BIAS, stringBuilder.toString());
        }
        return this;
    }

    public InferenceParameters setStopStrings(String ... stringArray) {
        if (stringArray.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuilder.append(this.toJsonString(stringArray[i]));
                if (i >= stringArray.length - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("]");
            this.parameters.put(PARAM_STOP, stringBuilder.toString());
        }
        return this;
    }

    public InferenceParameters setSamplers(Sampler ... samplerArray) {
        if (samplerArray.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            for (int i = 0; i < samplerArray.length; ++i) {
                switch (samplerArray[i]) {
                    case TOP_K: {
                        stringBuilder.append("\"top_k\"");
                        break;
                    }
                    case TFS_Z: {
                        stringBuilder.append("\"tfs_z\"");
                        break;
                    }
                    case TYPICAL_P: {
                        stringBuilder.append("\"typical_p\"");
                        break;
                    }
                    case TOP_P: {
                        stringBuilder.append("\"top_p\"");
                        break;
                    }
                    case MIN_P: {
                        stringBuilder.append("\"min_p\"");
                        break;
                    }
                    case TEMPERATURE: {
                        stringBuilder.append("\"temperature\"");
                    }
                }
                if (i >= samplerArray.length - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("]");
            this.parameters.put(PARAM_SAMPLERS, stringBuilder.toString());
        }
        return this;
    }

    InferenceParameters setStream(boolean bl) {
        this.parameters.put(PARAM_STREAM, String.valueOf(bl));
        return this;
    }

    public InferenceParameters setUseChatTemplate(boolean bl) {
        this.parameters.put(PARAM_USE_CHAT_TEMPLATE, String.valueOf(bl));
        return this;
    }

    public InferenceParameters setImageData(String string, int n) {
        String string2 = this.toJsonString(string);
        String string3 = "[{\"data\":" + string2 + ", \"id\": " + n + "}]";
        this.parameters.put(PARAM_IMAGE_DATA, string3);
        return this;
    }
}

